/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.rzo.netty.ahessian.rpc.message.FlushRequestMessage;
import org.rzo.netty.ahessian.rpc.message.GroupedMessage;
import org.rzo.netty.ahessian.stopable.StopableHandler;
import org.rzo.netty.ahessian.utils.TimedBlockingPriorityQueue;

public class OutputProducer
extends SimpleChannelHandler
implements StopableHandler {
    private TimedBlockingPriorityQueue<MessageEvent> _pendingCalls = new TimedBlockingPriorityQueue("OutputProducer");
    AtomicInteger _producerThreadsCount = new AtomicInteger(0);
    Lock _lock = new ReentrantLock();
    Executor _executor;
    Timer _timer;
    List<MessageEvent> _pendingTermination = new ArrayList<MessageEvent>();
    volatile boolean _stop = false;

    public OutputProducer(Executor executor) {
        this._executor = executor;
    }

    public void writeRequested(final ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        GroupedMessage m = (GroupedMessage)e.getMessage();
        this._pendingCalls.put(e, m.getGroup());
        if (this._producerThreadsCount.get() < 2) {
            this._executor.execute(new Runnable(){

                public void run() {
                    OutputProducer.this.produce(ctx);
                }
            });
        }
    }

    public void channelConnected(final ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendUpstream((ChannelEvent)e);
        this._executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Iterator<MessageEvent> it = OutputProducer.this._pendingTermination.iterator();
                while (it.hasNext()) {
                    OutputProducer.this._lock.lock();
                    try {
                        if (OutputProducer.this._stop) {
                            return;
                        }
                        MessageEvent e = it.next();
                        GroupedMessage m = (GroupedMessage)e.getMessage();
                        OutputProducer.this._pendingCalls.put(e, m.getGroup());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        OutputProducer.this._lock.unlock();
                    }
                }
                OutputProducer.this.produce(ctx);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produce(ChannelHandlerContext ctx) {
        if (this._stop) {
            return;
        }
        if (this._producerThreadsCount.incrementAndGet() > 2) {
            this._producerThreadsCount.decrementAndGet();
            return;
        }
        boolean produced = false;
        this._lock.lock();
        try {
            MessageEvent toSend = null;
            while (ctx.getChannel().isConnected() && this._pendingCalls.size() > 0) {
                if (this._stop) {
                    return;
                }
                try {
                    toSend = this._pendingCalls.take();
                    ctx.sendDownstream((ChannelEvent)toSend);
                    this._pendingTermination.add(toSend);
                    produced = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this._pendingCalls.put(toSend, ((GroupedMessage)toSend.getMessage()).getGroup());
                }
            }
            if (produced && this._pendingCalls.size() == 0) {
                Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future((Channel)ctx.getChannel()), (Object)new FlushRequestMessage());
                Iterator<MessageEvent> it = this._pendingTermination.iterator();
                while (it.hasNext()) {
                    if (this._stop) {
                        return;
                    }
                    try {
                        MessageEvent e = it.next();
                        GroupedMessage m = (GroupedMessage)e.getMessage();
                        it.remove();
                        e.getFuture().setSuccess();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this._producerThreadsCount.decrementAndGet();
            this._lock.unlock();
        }
    }

    public boolean isStopEnabled() {
        return true;
    }

    public void setStopEnabled(boolean stopEnabled) {
    }

    public void stop() {
        this._stop = true;
        for (MessageEvent event : this._pendingCalls) {
            event.getFuture().cancel();
        }
    }
}

