/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.rzo.netty.ahessian.rpc.client.AsyncHessianProxy;

public class SyncHessianProxy
implements InvocationHandler {
    AsyncHessianProxy _handler;
    long _defaultTimeout = -1L;

    SyncHessianProxy(InvocationHandler handler) {
        this._handler = (AsyncHessianProxy)handler;
        if (this._handler._options != null && this._handler._options.get("timeout") != null) {
            this._defaultTimeout = (Long)this._handler._options.get("timeout");
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("equals".equals(method.getName()) || "hashCode".equals(method.getName()) || "getHessianType".equals(method.getName()) || "getHessianURL".equals(method.getName())) {
            return this._handler.invoke(proxy, method, args);
        }
        if ("toString".equals(method.getName())) {
            return "Sync:" + this._handler.invoke(proxy, method, args);
        }
        long timeout = this.getTimeout(method.getName());
        if (timeout > 0L) {
            return ((Future)this._handler.invoke(proxy, method, args)).get(timeout, TimeUnit.MILLISECONDS);
        }
        return ((Future)this._handler.invoke(proxy, method, args)).get();
    }

    private long getTimeout(String method) {
        if (this._handler._options != null && this._handler._options.get("timeout." + method) != null) {
            return (Long)this._handler._options.get("timeout." + method);
        }
        return this._defaultTimeout;
    }
}

