/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.client;

import java.net.ConnectException;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.client.BootstrapProvider;

public class ReconnectHandler
extends SimpleChannelUpstreamHandler {
    private Timer _timer;
    private long RECONNECT_DELAY = 5000L;
    private BootstrapProvider _bootstrap;
    private volatile boolean _stop = false;
    private volatile Timeout _timeout;

    public ReconnectHandler(BootstrapProvider bootstrap, long reconnectDelay, Timer timer) {
        this.RECONNECT_DELAY = reconnectDelay;
        this._bootstrap = bootstrap;
        this._timer = timer;
    }

    public ReconnectHandler(BootstrapProvider bootstrap) {
        this._bootstrap = bootstrap;
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        ctx.sendUpstream((ChannelEvent)e);
        if (this._stop) {
            return;
        }
        if (this._timeout != null) {
            return;
        }
        Constants.ahessianLogger.warn("channel closed wait to reconnect ...");
        this._timeout = this._timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                ReconnectHandler.this._timeout = null;
                ReconnectHandler.this.connect(ReconnectHandler.this._bootstrap.getBootstrap());
            }
        }, this.RECONNECT_DELAY, TimeUnit.MILLISECONDS);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        Throwable cause = e.getCause();
        cause.printStackTrace();
        if (cause instanceof ConnectException) {
            Constants.ahessianLogger.warn("conection lost");
        }
        try {
            ctx.getChannel().close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void stop() {
        this._stop = true;
        Timeout timeout = this._timeout;
        this._timeout = null;
        timeout.cancel();
    }

    protected void connect(ClientBootstrap bootstrap) {
        Constants.ahessianLogger.warn("reconnecting...");
        ChannelFuture f = this._bootstrap.getBootstrap().connect();
        try {
            f.awaitUninterruptibly();
        }
        catch (Exception e) {
            Constants.ahessianLogger.warn("", (Throwable)e);
        }
        if (f.isSuccess()) {
            Constants.ahessianLogger.warn("connected");
        } else {
            Constants.ahessianLogger.warn("not connected");
        }
    }
}

