/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.crypto;

import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.rzo.netty.ahessian.crypto.CryptoConstants;
import org.rzo.netty.ahessian.crypto.StreamCipher;
import org.rzo.netty.ahessian.crypto.StreamCipherFactory;
import org.rzo.netty.ahessian.crypto.Util;
import org.rzo.netty.ahessian.log.OutLogger;

public class ServerCryptoFilter
extends SimpleChannelHandler
implements CryptoConstants {
    KeyPair _serverKeyPair;
    Key _clientKey;
    ChannelStateEvent _connectedEvent;
    private StreamCipher _encodeCipher;
    private StreamCipher _decodeCipher;
    private byte[] _cryptedIvKeyMessage;
    private int _bytesRead;

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.sendByteArray(ctx, this.getPublicKeyEncoded());
        this._connectedEvent = e;
    }

    private void sendByteArray(ChannelHandlerContext ctx, byte[] buffer) {
        try {
            Channel channel = ctx.getChannel();
            ChannelFuture future = Channels.future((Channel)ctx.getChannel());
            ChannelBuffer b = ChannelBuffers.dynamicBuffer();
            b.writeInt(buffer.length);
            b.writeBytes(buffer);
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)future, (Object)b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    byte[] getPublicKeyEncoded() {
        try {
            SecureRandom random = new SecureRandom();
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(512, random);
            this._serverKeyPair = generator.generateKeyPair();
            PublicKey pubKey = this._serverKeyPair.getPublic();
            return pubKey.getEncoded();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this._decodeCipher != null) {
            MessageEvent m = Util.code(this._decodeCipher, e, true);
            ctx.sendUpstream((ChannelEvent)m);
        } else {
            ChannelBuffer b = (ChannelBuffer)e.getMessage();
            if (this._cryptedIvKeyMessage == null) {
                int size = b.readInt();
                if (size > 1024) {
                    ctx.getChannel().close();
                    return;
                }
                this._cryptedIvKeyMessage = new byte[size];
            }
            int available = b.readableBytes();
            int toRead = Math.min(this._cryptedIvKeyMessage.length - this._bytesRead, available);
            b.readBytes(this._cryptedIvKeyMessage, this._bytesRead, toRead);
            this._bytesRead += toRead;
            if (this._bytesRead == this._cryptedIvKeyMessage.length) {
                boolean ok = false;
                try {
                    this.createCiphers();
                    ok = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    ctx.getChannel().close();
                }
                if (ok) {
                    ctx.sendUpstream((ChannelEvent)this._connectedEvent);
                }
            }
        }
    }

    private void createCiphers() throws Exception {
        String type = "".equals("ECB/NOPADDING") ? "RSA" : "RSA/ECB/NOPADDING";
        Cipher asymCipher = Cipher.getInstance(type);
        asymCipher.init(2, this._serverKeyPair.getPrivate());
        byte[] data = asymCipher.doFinal(this._cryptedIvKeyMessage);
        System.out.println("received iv+key: " + OutLogger.asString(data));
        byte[] iv = new byte[8];
        System.arraycopy(data, data.length - 24, iv, 0, iv.length);
        System.out.println("received iv: " + OutLogger.asString(iv));
        byte[] key = new byte[16];
        System.arraycopy(data, data.length - 16, key, 0, key.length);
        System.out.println("received key: " + OutLogger.asString(key));
        this._encodeCipher = StreamCipherFactory.createCipher("RC4");
        this._encodeCipher.engineInitEncrypt(key, iv);
        this._decodeCipher = StreamCipherFactory.createCipher("RC4");
        this._decodeCipher.engineInitDecrypt(key, iv);
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this._encodeCipher != null) {
            MessageEvent m = Util.code(this._encodeCipher, e, false);
            ctx.sendDownstream((ChannelEvent)m);
        }
    }

    public static void main(String[] args) {
        ServerCryptoFilter h = new ServerCryptoFilter();
        h.getPublicKeyEncoded();
    }
}

