/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.ipfilter;

import java.net.InetSocketAddress;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.ipfilter.IpFilterListener;
import org.jboss.netty.handler.ipfilter.IpFilteringHandler;

public abstract class IpFilteringHandlerImpl
implements IpFilteringHandler {
    private IpFilterListener listener = null;

    protected abstract boolean accept(ChannelHandlerContext var1, ChannelEvent var2, InetSocketAddress var3) throws Exception;

    protected ChannelFuture handleRefusedChannel(ChannelHandlerContext ctx, ChannelEvent e, InetSocketAddress inetSocketAddress) throws Exception {
        if (this.listener == null) {
            return null;
        }
        ChannelFuture result = this.listener.refused(ctx, e, inetSocketAddress);
        return result;
    }

    protected ChannelFuture handleAllowedChannel(ChannelHandlerContext ctx, ChannelEvent e, InetSocketAddress inetSocketAddress) throws Exception {
        if (this.listener == null) {
            return null;
        }
        ChannelFuture result = this.listener.allowed(ctx, e, inetSocketAddress);
        return result;
    }

    protected boolean isBlocked(ChannelHandlerContext ctx) {
        return ctx.getAttachment() != null;
    }

    protected boolean continues(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (this.listener != null) {
            return this.listener.continues(ctx, e);
        }
        return false;
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent evt = (ChannelStateEvent)e;
            switch (evt.getState()) {
                case OPEN: 
                case BOUND: {
                    if (this.isBlocked(ctx) && !this.continues(ctx, (ChannelEvent)evt)) {
                        return;
                    }
                    ctx.sendUpstream(e);
                    return;
                }
                case CONNECTED: {
                    if (evt.getValue() != null) {
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)e.getChannel().getRemoteAddress();
                        if (!this.accept(ctx, e, inetSocketAddress)) {
                            ctx.setAttachment((Object)Boolean.TRUE);
                            ChannelFuture future = this.handleRefusedChannel(ctx, e, inetSocketAddress);
                            if (future != null) {
                                future.addListener(ChannelFutureListener.CLOSE);
                            } else {
                                Channels.close((Channel)e.getChannel());
                            }
                            if (this.isBlocked(ctx) && !this.continues(ctx, (ChannelEvent)evt)) {
                                return;
                            }
                        } else {
                            this.handleAllowedChannel(ctx, e, inetSocketAddress);
                        }
                        ctx.setAttachment(null);
                        break;
                    }
                    if (!this.isBlocked(ctx) || this.continues(ctx, (ChannelEvent)evt)) break;
                    return;
                }
            }
        }
        if (this.isBlocked(ctx) && !this.continues(ctx, e)) {
            return;
        }
        ctx.sendUpstream(e);
    }

    public void setIpFilterListener(IpFilterListener listener) {
        this.listener = listener;
    }

    public void removeIpFilterListener() {
        this.listener = null;
    }
}

