/*
 * $Id$
 *
 * Firebird Open Source JavaEE Connector - JDBC Driver
 *
 * Distributable under LGPL license.
 * You may obtain a copy of the License at http://www.gnu.org/copyleft/lgpl.html
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * LGPL License for more details.
 *
 * This file was created by members of the firebird development team.
 * All individual contributions remain the Copyright (C) of those
 * individuals.  Contributors to this file are either listed here or
 * can be obtained from a source control history command.
 *
 * All rights reserved.
 */
package org.firebirdsql.jna.fbclient;

import com.sun.jna.Structure;
import org.firebirdsql.gds.ISCConstants;

import java.util.Arrays;
import java.util.List;

/**
 * JNA Wrapper for XSQLDA.
 * <p>
 * This file was initially autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>, a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.
 * </p>
 * <p>
 * This file was modified manually, <strong>do not automatically regenerate!</strong>
 * </p>
 * @since 3.0
 */
public class XSQLDA extends Structure {
	/// C type : ISC_SHORT
	public short version = ISCConstants.SQLDA_VERSION1;
	/// C type : ISC_SCHAR[8]
	public byte[] sqldaid = new byte[8];
	/// C type : ISC_LONG
	public int sqldabc;
	/// C type : ISC_SHORT
	public short sqln;
	/// C type : ISC_SHORT
	public short sqld;
	/// C type : XSQLVAR[1]
	public XSQLVAR[] sqlvar;

    public XSQLDA() {
        this(1);
	}

    public XSQLDA(int size) {
        sqld = sqln = (short) size;
        sqlvar = (XSQLVAR[]) new XSQLVAR().toArray(size);
        allocateMemory();
    }

    @Override
    protected List getFieldOrder() {
        return Arrays.asList("version", "sqldaid", "sqldabc", "sqln", "sqld", "sqlvar");
    }

	/**
	 * @param version C type : ISC_SHORT<br>
	 * @param sqldaid C type : ISC_SCHAR[8]<br>
	 * @param sqldabc C type : ISC_LONG<br>
	 * @param sqln C type : ISC_SHORT<br>
	 * @param sqld C type : ISC_SHORT<br>
	 * @param sqlvar C type : XSQLVAR[1]
	 */
	public XSQLDA(short version, byte sqldaid[], int sqldabc, short sqln, short sqld, XSQLVAR sqlvar[]) {
		super();
		this.version = version;
		if (sqldaid.length != this.sqldaid.length) 
			throw new IllegalArgumentException("Wrong array size !");
		this.sqldaid = sqldaid;
		this.sqldabc = sqldabc;
		this.sqln = sqln;
		this.sqld = sqld;
		if (sqlvar.length != this.sqln)
			throw new IllegalArgumentException("Wrong array size !");
		this.sqlvar = (XSQLVAR[]) new XSQLVAR().toArray(sqlvar);
        allocateMemory();
	}

	public static class ByReference extends XSQLDA implements Structure.ByReference {
	}

	public static class ByValue extends XSQLDA implements Structure.ByValue {
	}
}
