/*
 * Firebird Open Source JavaEE Connector - JDBC Driver
 *
 * Distributable under LGPL license.
 * You may obtain a copy of the License at http://www.gnu.org/copyleft/lgpl.html
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * LGPL License for more details.
 *
 * This file was created by members of the firebird development team.
 * All individual contributions remain the Copyright (C) of those
 * individuals.  Contributors to this file are either listed here or
 * can be obtained from a source control history command.
 *
 * All rights reserved.
 */
package org.firebirdsql.jdbc;

import java.sql.BatchUpdateException;

/**
 * JDBC 4.2 version support.
 *
 * @author <a href="mailto:mrotteveel@users.sourceforge.net">Mark Rotteveel</a>
 * @since 3.0
 */
@SuppressWarnings("Since15")
public final class Jdbc42VersionSupport implements JdbcVersionSupport {

    @Override
    public BatchUpdateException createBatchUpdateException(String reason, String SQLState, int vendorCode,
            long[] updateCounts, Throwable cause) {
        return new BatchUpdateException(reason, SQLState, vendorCode, updateCounts, cause);
    }
}
