/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.firebirdsql.gds.ng.jna.AbstractNativeDatabaseFactory;
import org.firebirdsql.gds.ng.jna.NativeLibraryLoadException;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.WinFbClientLibrary;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public final class FbClientDatabaseFactory
extends AbstractNativeDatabaseFactory {
    private static final Logger log = LoggerFactory.getLogger(FbClientDatabaseFactory.class);
    private static final List<String> LIBRARIES_TO_TRY = Collections.unmodifiableList(Arrays.asList("fbclient", "fbclient_x64"));
    private static final FbClientDatabaseFactory INSTANCE = new FbClientDatabaseFactory();

    public static FbClientDatabaseFactory getInstance() {
        return INSTANCE;
    }

    @Override
    protected FbClientLibrary createClientLibrary() {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        for (String libraryName : LIBRARIES_TO_TRY) {
            try {
                if (Platform.isWindows()) {
                    return (FbClientLibrary)Native.loadLibrary((String)libraryName, WinFbClientLibrary.class);
                }
                return (FbClientLibrary)Native.loadLibrary((String)libraryName, FbClientLibrary.class);
            }
            catch (RuntimeException | UnsatisfiedLinkError e) {
                throwables.add(e);
                log.debug("Attempt to load " + libraryName + " failed", e);
            }
        }
        assert (throwables.size() == LIBRARIES_TO_TRY.size());
        log.error("Could not load any of the libraries in " + LIBRARIES_TO_TRY + ":");
        for (int idx = 0; idx < LIBRARIES_TO_TRY.size(); ++idx) {
            log.error("Loading " + LIBRARIES_TO_TRY.get(idx) + " failed", (Throwable)throwables.get(idx));
        }
        throw new NativeLibraryLoadException("Could not load any of " + LIBRARIES_TO_TRY + "; linking first exception", (Throwable)throwables.get(0));
    }
}

