/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.resource.Referenceable;
import javax.sql.DataSource;
import org.firebirdsql.ds.RootCommonDataSource;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.jdbc.FBConnectionProperties;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.pool.AbstractFBConnectionPoolDataSource;
import org.firebirdsql.pool.BasicAbstractConnectionPool;
import org.firebirdsql.pool.FBPooledDataSourceFactory;
import org.firebirdsql.pool.FirebirdPool;

public class FBWrappingDataSource
extends RootCommonDataSource
implements DataSource,
ObjectFactory,
Referenceable,
Serializable,
FirebirdPool {
    private static final long serialVersionUID = -2282667414407311473L;
    private AbstractFBConnectionPoolDataSource pool;
    private Reference reference;
    private String description;
    private static final String REF_BLOCKING_TIMEOUT = "blockingTimeout";
    private static final String REF_DESCRIPTION = "description";
    private static final String REF_MAX_IDLE_TIME = "maxIdleTime";
    private static final String REF_IDLE_TIMEOUT = "idleTimeout";
    private static final String REF_LOGIN_TIMEOUT = "loginTimeout";
    private static final String REF_MAX_POOL_SIZE = "maxPoolSize";
    private static final String REF_MIN_POOL_SIZE = "minPoolSize";
    private static final String REF_MAX_CONNECTIONS = "maxConnections";
    private static final String REF_MIN_CONNECTIONS = "minConnections";
    private static final String REF_PING_INTERVAL = "pingInterval";
    private static final String REF_RETRY_INTERVAL = "retryInterval";
    private static final String REF_POOLING = "pooling";
    private static final String REF_STATEMENT_POOLING = "statementPooling";
    private static final String REF_PING_STATEMENT = "pingStatement";
    private static final String REF_PROPERTIES = "properties";
    private static final String REF_NON_STANDARD_PROPERTY = "nonStandard";

    private synchronized AbstractFBConnectionPoolDataSource getPool() {
        if (this.pool == null) {
            this.pool = FBPooledDataSourceFactory.createFBConnectionPoolDataSource();
        }
        return this.pool;
    }

    protected void finalize() throws Throwable {
        if (this.pool != null) {
            this.pool.shutdown();
        }
        super.finalize();
    }

    @Override
    public void restart() {
        if (this.pool != null) {
            this.pool.restart();
        }
    }

    @Override
    public void shutdown() {
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getPool().getPooledConnection().getConnection();
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        return this.getPool().getPooledConnection(user, password).getConnection();
    }

    @Override
    public int getLoginTimeout() {
        return this.getBlockingTimeout() * 1000;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.getPool().getLogWriter();
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.setBlockingTimeout(seconds * 1000);
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        this.getPool().setLogWriter(printWriter);
    }

    @Override
    public int getBlockingTimeout() {
        return this.getPool().getBlockingTimeout();
    }

    @Override
    public void setBlockingTimeout(int blockingTimeoutValue) {
        this.getPool().setBlockingTimeout(blockingTimeoutValue);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String descriptionValue) {
        this.description = descriptionValue;
    }

    @Override
    public int getMaxIdleTime() {
        return this.getPool().getMaxIdleTime();
    }

    @Override
    public void setMaxIdleTime(int maxIdleTime) {
        this.getPool().setMaxIdleTime(maxIdleTime);
    }

    @Override
    public int getIdleTimeout() {
        return this.getPool().getIdleTimeout();
    }

    public void setIdleTimeout(int idleTimeoutValue) {
        this.getPool().setIdleTimeout(idleTimeoutValue);
    }

    @Override
    public int getMaxStatements() {
        return this.getPool().getMaxStatements();
    }

    @Override
    public void setMaxStatements(int maxStatements) {
        this.getPool().setMaxStatements(maxStatements);
    }

    @Override
    public int getMaxPoolSize() {
        return this.getPool().getMaxPoolSize();
    }

    @Override
    public void setMaxPoolSize(int maxPoolSize) {
        this.getPool().setMaxPoolSize(maxPoolSize);
    }

    @Override
    public int getMaxConnections() {
        return this.getPool().getMaxConnections();
    }

    public void setMaxConnections(int maxConnections) {
        this.getPool().setMaxConnections(maxConnections);
    }

    @Override
    public int getMinPoolSize() {
        return this.getPool().getMinPoolSize();
    }

    @Override
    public void setMinPoolSize(int minPoolSize) {
        this.getPool().setMinPoolSize(minPoolSize);
    }

    @Override
    public int getMinConnections() {
        return this.getMinPoolSize();
    }

    public void setMinConnections(int minConnections) {
        this.setMinPoolSize(minConnections);
    }

    public boolean isKeepStatements() {
        return this.getPool().isKeepStatements();
    }

    public void setKeepStatements(boolean keepStatements) {
        this.getPool().setKeepStatements(keepStatements);
    }

    @Override
    public int getPingInterval() {
        return this.getPool().getPingInterval();
    }

    @Override
    public void setPingInterval(int pingIntervalValue) {
        this.getPool().setPingInterval(pingIntervalValue);
    }

    @Override
    public String getPingStatement() {
        return this.getPool().getPingStatement();
    }

    public void setPingStatement(String pingStatement) {
        this.getPool().setPingStatement(pingStatement);
    }

    @Override
    public int getRetryInterval() {
        return this.getPool().getRetryInterval();
    }

    public void setRetryInterval(int retryInterval) {
        this.getPool().setRetryInterval(retryInterval);
    }

    @Override
    public boolean isPingable() {
        return this.getPool().isPingable();
    }

    public String getSqlRole() {
        return this.getRoleName();
    }

    public void setSqlRole(String sqlRole) {
        this.setRoleName(sqlRole);
    }

    public boolean getPooling() {
        return this.getPool().isPooling();
    }

    @Override
    public boolean isPooling() {
        return this.getPool().isPooling();
    }

    @Override
    public void setPooling(boolean pooling) {
        this.getPool().setPooling(pooling);
    }

    @Override
    public boolean isStatementPooling() {
        return this.getPool().isStatementPooling();
    }

    @Override
    public void setStatementPooling(boolean statementPooling) {
        this.getPool().setStatementPooling(statementPooling);
    }

    public int getConnectionCount() throws SQLException {
        return this.getPool().getFreeSize();
    }

    @Override
    public int getFreeSize() throws SQLException {
        return this.getPool().getFreeSize();
    }

    @Override
    public int getWorkingSize() throws SQLException {
        return this.getPool().getWorkingSize();
    }

    @Override
    public int getTotalSize() throws SQLException {
        return this.getPool().getTotalSize();
    }

    public int getTransactionIsolationLevel() {
        return this.getDefaultTransactionIsolation();
    }

    public void setTransactionIsolationLevel(int level) {
        this.setDefaultTransactionIsolation(level);
    }

    public String getIsolation() {
        return this.getDefaultIsolation();
    }

    public void setIsolation(String isolation) throws SQLException {
        this.setDefaultIsolation(isolation);
    }

    public void setProperties(Properties props) {
        this.getPool().setProperties(props);
    }

    @Override
    public int getBlobBufferSize() {
        return this.getPool().getBlobBufferSize();
    }

    @Override
    public int getBuffersNumber() {
        return this.getPool().getBuffersNumber();
    }

    @Override
    public String getCharSet() {
        return this.getPool().getCharSet();
    }

    @Override
    public String getDatabase() {
        return this.getPool().getDatabase();
    }

    @Override
    public DatabaseParameterBuffer getDatabaseParameterBuffer() throws SQLException {
        return this.getPool().getDatabaseParameterBuffer();
    }

    @Override
    public String getDefaultIsolation() {
        return this.getPool().getDefaultIsolation();
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return this.getPool().getDefaultTransactionIsolation();
    }

    @Override
    public String getEncoding() {
        return this.getPool().getEncoding();
    }

    @Override
    public String getNonStandardProperty(String key) {
        return this.getPool().getNonStandardProperty(key);
    }

    @Override
    public String getPassword() {
        return this.getPool().getPassword();
    }

    @Override
    public String getRoleName() {
        return this.getPool().getRoleName();
    }

    @Override
    public int getSocketBufferSize() {
        return this.getPool().getSocketBufferSize();
    }

    @Override
    public String getSqlDialect() {
        return this.getPool().getSqlDialect();
    }

    @Override
    public String getTpbMapping() {
        return this.getPool().getTpbMapping();
    }

    @Override
    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        return this.getPool().getTransactionParameters(isolation);
    }

    @Override
    public String getType() {
        return this.getPool().getType();
    }

    @Override
    public String getUserName() {
        return this.getPool().getUserName();
    }

    @Override
    public String getUseTranslation() {
        return this.getPool().getUseTranslation();
    }

    @Override
    public boolean isTimestampUsesLocalTimezone() {
        return this.getPool().isTimestampUsesLocalTimezone();
    }

    @Override
    public boolean isUseStandardUdf() {
        return this.getPool().isUseStandardUdf();
    }

    @Override
    public boolean isUseStreamBlobs() {
        return this.getPool().isUseStreamBlobs();
    }

    @Override
    public void setBlobBufferSize(int bufferSize) {
        this.getPool().setBlobBufferSize(bufferSize);
    }

    @Override
    public void setBuffersNumber(int buffersNumber) {
        this.getPool().setBuffersNumber(buffersNumber);
    }

    @Override
    public void setCharSet(String charSet) {
        this.getPool().setCharSet(charSet);
    }

    @Override
    public void setDatabase(String database) {
        this.getPool().setDatabase(database);
    }

    @Override
    public void setDefaultIsolation(String isolation) {
        this.getPool().setDefaultIsolation(isolation);
    }

    @Override
    public void setDefaultTransactionIsolation(int defaultIsolationLevel) {
        this.getPool().setDefaultTransactionIsolation(defaultIsolationLevel);
    }

    @Override
    public void setEncoding(String encoding) {
        this.getPool().setEncoding(encoding);
    }

    @Override
    public void setNonStandardProperty(String key, String value) {
        this.getPool().setNonStandardProperty(key, value);
    }

    @Override
    public void setNonStandardProperty(String propertyMapping) {
        this.getPool().setNonStandardProperty(propertyMapping);
    }

    @Override
    public void setPassword(String password) {
        this.getPool().setPassword(password);
    }

    @Override
    public void setRoleName(String roleName) {
        this.getPool().setRoleName(roleName);
    }

    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        this.getPool().setSocketBufferSize(socketBufferSize);
    }

    @Override
    public void setSqlDialect(String sqlDialect) {
        this.getPool().setSqlDialect(sqlDialect);
    }

    @Override
    public void setTimestampUsesLocalTimezone(boolean timestampUsesLocalTimezone) {
        this.getPool().setTimestampUsesLocalTimezone(timestampUsesLocalTimezone);
    }

    @Override
    public void setTpbMapping(String tpbMapping) {
        this.getPool().setTpbMapping(tpbMapping);
    }

    @Override
    public void setTransactionParameters(int isolation, TransactionParameterBuffer tpb) {
        this.getPool().setTransactionParameters(isolation, tpb);
    }

    @Override
    public void setType(String type) {
        this.getPool().setType(type);
    }

    @Override
    public void setUserName(String userName) {
        this.getPool().setUserName(userName);
    }

    @Override
    public void setUseStandardUdf(boolean useStandardUdf) {
        this.getPool().setUseStandardUdf(useStandardUdf);
    }

    @Override
    public void setUseStreamBlobs(boolean useStreamBlobs) {
        this.getPool().setUseStreamBlobs(useStreamBlobs);
    }

    @Override
    public void setUseTranslation(String translationPath) {
        this.getPool().setUseTranslation(translationPath);
    }

    @Override
    public boolean isDefaultResultSetHoldable() {
        return this.getPool().isDefaultResultSetHoldable();
    }

    @Override
    public void setDefaultResultSetHoldable(boolean isHoldable) {
        this.getPool().setDefaultResultSetHoldable(isHoldable);
    }

    @Override
    public int getSoTimeout() {
        return this.getPool().getSoTimeout();
    }

    @Override
    public void setSoTimeout(int soTimeout) {
        this.getPool().setSoTimeout(soTimeout);
    }

    @Override
    public int getConnectTimeout() {
        return this.getPool().getConnectTimeout();
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.getPool().setConnectTimeout(connectTimeout);
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (!(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        ref = (Reference)ref.clone();
        if (!this.getClass().getName().equals(ref.getClassName())) {
            return null;
        }
        FBWrappingDataSource ds = new FBWrappingDataSource();
        for (int i = 0; i < ref.size(); ++i) {
            RefAddr element = ref.get(i);
            String type = element.getType();
            if (REF_BLOCKING_TIMEOUT.equals(type)) {
                ds.setBlockingTimeout(Integer.parseInt(element.getContent().toString()));
            } else if (REF_DESCRIPTION.equals(type)) {
                ds.setDescription(element.getContent().toString());
            } else if (REF_IDLE_TIMEOUT.equals(type)) {
                ds.setIdleTimeout(Integer.parseInt(element.getContent().toString()));
            } else if (REF_MAX_IDLE_TIME.equals(type)) {
                ds.setMaxIdleTime(Integer.parseInt(element.getContent().toString()));
            } else if (REF_LOGIN_TIMEOUT.equals(type)) {
                ds.setLoginTimeout(Integer.parseInt(element.getContent().toString()));
            } else if (REF_MAX_POOL_SIZE.equals(type)) {
                ds.setMaxPoolSize(Integer.parseInt(element.getContent().toString()));
            } else if (REF_MIN_POOL_SIZE.equals(type)) {
                ds.setMinPoolSize(Integer.parseInt(element.getContent().toString()));
            } else if (REF_MIN_CONNECTIONS.equals(type)) {
                ds.setMinConnections(Integer.parseInt(element.getContent().toString()));
            } else if (REF_MAX_CONNECTIONS.equals(type)) {
                ds.setMaxConnections(Integer.parseInt(element.getContent().toString()));
            } else if (REF_PING_INTERVAL.equals(type)) {
                ds.setPingInterval(Integer.parseInt(element.getContent().toString()));
            } else if (REF_RETRY_INTERVAL.equals(type)) {
                ds.setRetryInterval(Integer.parseInt(element.getContent().toString()));
            } else if (REF_POOLING.equals(type)) {
                ds.setPooling(Boolean.valueOf(element.getContent().toString()));
            } else if (REF_STATEMENT_POOLING.equals(type)) {
                ds.setStatementPooling(Boolean.valueOf(element.getContent().toString()));
            } else if (REF_PING_STATEMENT.equals(type)) {
                ds.setPingStatement(element.getContent().toString());
            }
            if (REF_NON_STANDARD_PROPERTY.equals(type)) {
                ds.setNonStandardProperty(element.getContent().toString());
                continue;
            }
            if (REF_PROPERTIES.equals(type)) {
                byte[] data = (byte[])element.getContent();
                FBConnectionProperties props = (FBConnectionProperties)BasicAbstractConnectionPool.deserialize(data);
                ds.getPool().setConnectionProperties(props);
                continue;
            }
            if (!(element.getContent() instanceof String)) continue;
            ds.setNonStandardProperty(type, element.getContent().toString());
        }
        return ds;
    }

    public Reference getReference() {
        if (this.reference == null) {
            return this.getDefaultReference();
        }
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getDefaultReference() {
        Reference ref = new Reference(this.getClass().getName(), this.getClass().getName(), null);
        if (this.getBlockingTimeout() != 5000) {
            ref.add(new StringRefAddr(REF_BLOCKING_TIMEOUT, String.valueOf(this.getBlockingTimeout())));
        }
        if (this.getDescription() != null) {
            ref.add(new StringRefAddr(REF_DESCRIPTION, this.getDescription()));
        }
        if (this.getMaxIdleTime() != 2147483) {
            ref.add(new StringRefAddr(REF_MAX_IDLE_TIME, String.valueOf(this.getMaxIdleTime())));
        }
        if (this.getLoginTimeout() != 5) {
            ref.add(new StringRefAddr(REF_LOGIN_TIMEOUT, String.valueOf(this.getLoginTimeout())));
        }
        if (this.getMaxPoolSize() != 10) {
            ref.add(new StringRefAddr(REF_MAX_POOL_SIZE, String.valueOf(this.getMaxPoolSize())));
        }
        if (this.getMinPoolSize() != 0) {
            ref.add(new StringRefAddr(REF_MIN_POOL_SIZE, String.valueOf(this.getMinPoolSize())));
        }
        if (this.getPingInterval() != 5000) {
            ref.add(new StringRefAddr(REF_PING_INTERVAL, String.valueOf(this.getPingInterval())));
        }
        if (this.getRetryInterval() != 1000) {
            ref.add(new StringRefAddr(REF_RETRY_INTERVAL, String.valueOf(this.getRetryInterval())));
        }
        if (!this.isPooling()) {
            ref.add(new StringRefAddr(REF_POOLING, String.valueOf(this.isPooling())));
        }
        if (!this.isStatementPooling()) {
            ref.add(new StringRefAddr(REF_STATEMENT_POOLING, String.valueOf(this.isStatementPooling())));
        }
        ref.add(new StringRefAddr(REF_PING_STATEMENT, this.getPingStatement()));
        byte[] data = BasicAbstractConnectionPool.serialize(this.getPool().getConnectionProperties());
        ref.add(new BinaryRefAddr(REF_PROPERTIES, data));
        return ref;
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return false;
    }

    public Object unwrap(Class iface) throws SQLException {
        throw new FBDriverNotCapableException();
    }
}

