/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.jni;

import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.DbAttachInfo;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.impl.jni.JniGDSImpl;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class NativeGDSImpl
extends JniGDSImpl {
    private static Logger log = LoggerFactory.getLogger(NativeGDSImpl.class, false);
    private static final String[] CLIENT_LIBRARIES_TO_TRY = new String[]{"fbclient.dll", "fbclient_x64.dll", "libfbclient.so", "libfbclient_x64.so"};
    public static final String NATIVE_TYPE_NAME = "NATIVE";

    public NativeGDSImpl() {
        this(GDSType.getType(NATIVE_TYPE_NAME));
    }

    public NativeGDSImpl(GDSType gdsType) {
        super(gdsType);
        boolean logging;
        boolean bl = logging = log != null;
        if (logging) {
            log.info("Attempting to initilize native library.");
        }
        this.attemptToLoadAClientLibraryFromList(CLIENT_LIBRARIES_TO_TRY);
        if (logging) {
            log.info("Initilized native library OK.");
        }
    }

    @Override
    protected String getServerUrl(String file_name) throws GDSException {
        DbAttachInfo dbai;
        if (log != null) {
            log.debug("Original file name: " + file_name);
        }
        String fileName = (dbai = new DbAttachInfo(file_name)).getFileName().indexOf(58) == -1 && !dbai.getFileName().startsWith("/") ? dbai.getServer() + "/" + dbai.getPort() + ":" + "/" + dbai.getFileName() : dbai.getServer() + "/" + dbai.getPort() + ":" + dbai.getFileName();
        if (log != null) {
            log.debug("File name for native code: " + fileName);
        }
        return fileName;
    }
}

