/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.jvser.client;

import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public abstract class MainClass {
    protected final Logger log = Logger.getLogger(this.getClass());

    protected MainClass() {
    }

    protected abstract int run(String[] var1) throws Exception;

    protected abstract void usageMessage();

    protected void usageError() {
        this.usageMessage();
        System.exit(1);
    }

    protected void setupLogging(Level logLevel) {
        if (logLevel == null) {
            logLevel = Level.INFO;
        }
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)new PatternLayout("%p: %m%n"), "System.err");
        Logger.getRootLogger().removeAllAppenders();
        Logger.getRootLogger().addAppender((Appender)consoleAppender);
        Logger.getRootLogger().setLevel(logLevel);
    }

    protected final void errout(String message) {
        System.err.println(this.getClass().getSimpleName() + ": " + message);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMain(String[] args) {
        int exitValue = 1;
        try {
            exitValue = this.run(args);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            System.exit(exitValue);
        }
    }
}

