/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.jvser.client;

import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.dellroad.jvser.TelnetSerialPort;

public class Client
implements SerialPortEventListener {
    private static final String DATA_ENCODING = "ISO-8859-1";
    protected final Logger log = Logger.getLogger(this.getClass());
    private final InetAddress host;
    private final int tcpPort;
    private final boolean useThread;
    private final boolean logInput;
    private TelnetSerialPort port;
    private boolean done;
    private int baudRate = 9600;
    private int dataBits = 8;
    private int stopBits = 1;
    private int parity = 0;
    private int flowControl = 0;
    private boolean dtr = true;
    private boolean rts = true;

    public Client(InetAddress host, int tcpPort, boolean useThread, boolean logInput) {
        this.host = host;
        this.tcpPort = tcpPort;
        this.useThread = useThread;
        this.logInput = logInput;
    }

    public void run() throws Exception {
        Object reader;
        if (this.port != null) {
            throw new IllegalStateException();
        }
        this.port = new TelnetSerialPort();
        this.port.setSerialPortParams(this.baudRate, this.dataBits, this.stopBits, this.parity);
        this.port.setFlowControlMode(this.flowControl);
        this.port.addEventListener(this);
        this.port.notifyOnBreakInterrupt(true);
        this.port.notifyOnCarrierDetect(true);
        this.port.notifyOnCTS(true);
        this.port.notifyOnDataAvailable(true);
        this.port.notifyOnDSR(true);
        this.port.notifyOnFramingError(true);
        this.port.notifyOnOutputEmpty(true);
        this.port.notifyOnOverrunError(true);
        this.port.notifyOnParityError(true);
        this.port.notifyOnRingIndicator(true);
        this.port.setRTS(this.rts);
        this.port.setDTR(this.dtr);
        this.log.info((Object)("connecting to " + this.host + ":" + this.tcpPort));
        this.port.getTelnetClient().connect(this.host, this.tcpPort);
        this.port.getTelnetClient().setTcpNoDelay(true);
        if (this.useThread) {
            reader = new Thread(){

                @Override
                public void run() {
                    while (!Client.this.done) {
                        Client.this.readData();
                    }
                }
            };
            ((Thread)reader).setDaemon(false);
            ((Thread)reader).start();
        }
        this.log.info((Object)"available commands: !break !speed !geom !flow !rts !dtr !close");
        reader = new BufferedReader(new InputStreamReader(System.in, DATA_ENCODING));
        while (!this.done) {
            String line = ((BufferedReader)reader).readLine();
            if ((line = line + "\r\n").charAt(0) == '!') {
                String[] cmd = line.substring(1).trim().split("\\s");
                if (cmd.length == 0 || cmd[0].length() == 0) continue;
                if (cmd[0].equals("close")) {
                    this.done = true;
                    continue;
                }
                this.handleCommand(line.substring(1).trim().split("\\s"));
                continue;
            }
            byte[] data = line.getBytes(DATA_ENCODING);
            this.port.getOutputStream().write(data);
            this.port.getOutputStream().flush();
        }
        this.port.close();
    }

    private void handleCommand(String[] cmd) throws UnsupportedCommOperationException {
        if (cmd[0].equals("break") && cmd.length == 1) {
            this.port.sendBreak(500);
            return;
        }
        if (cmd[0].equals("speed") && cmd.length == 2) {
            try {
                this.baudRate = Integer.parseInt(cmd[1]);
            }
            catch (NumberFormatException e) {
                this.log.error((Object)("invalid baud rate: " + e));
                return;
            }
            this.log.info((Object)("setting baud rate to " + this.baudRate));
            this.port.setSerialPortParams(this.baudRate, this.dataBits, this.stopBits, this.parity);
            return;
        }
        if (cmd[0].equals("geom") && cmd.length == 2) {
            Matcher matcher = Pattern.compile("([5678])([NEOMS])(1|2|1.5)").matcher(cmd[1].toUpperCase());
            if (!matcher.matches()) {
                this.log.error((Object)("invalid geometry `" + cmd[1] + "'"));
                return;
            }
            switch (Integer.parseInt(matcher.group(1))) {
                case 5: {
                    this.dataBits = 5;
                    break;
                }
                case 6: {
                    this.dataBits = 6;
                    break;
                }
                case 7: {
                    this.dataBits = 7;
                    break;
                }
                case 8: {
                    this.dataBits = 8;
                    break;
                }
            }
            switch (matcher.group(2).charAt(0)) {
                case 'N': {
                    this.parity = 0;
                    break;
                }
                case 'E': {
                    this.parity = 2;
                    break;
                }
                case 'O': {
                    this.parity = 1;
                    break;
                }
                case 'M': {
                    this.parity = 3;
                    break;
                }
                case 'S': {
                    this.parity = 4;
                    break;
                }
            }
            if (matcher.group(3).equals("1")) {
                this.stopBits = 1;
            } else if (matcher.group(3).equals("2")) {
                this.stopBits = 2;
            } else if (matcher.group(3).equals("1.5")) {
                this.stopBits = 3;
            }
            this.log.info((Object)("setting geometry to " + cmd[1]));
            this.port.setSerialPortParams(this.baudRate, this.dataBits, this.stopBits, this.parity);
            return;
        }
        if (cmd[0].equals("flow") && cmd.length == 2) {
            if (cmd[1].equals("none")) {
                this.flowControl = 0;
            } else if (cmd[1].equals("xonxoff")) {
                this.flowControl = 12;
            } else if (cmd[1].equals("hardware") || cmd[1].equals("hw")) {
                this.flowControl = 3;
            } else {
                this.log.error((Object)("invalid flow control `" + cmd[1] + "': should be `none', `xonoff', or `hardware'"));
                return;
            }
            this.log.info((Object)("setting flow control mode to " + cmd[1]));
            this.port.setFlowControlMode(this.flowControl);
            return;
        }
        if (cmd[0].equals("dtr") && cmd.length == 2) {
            this.dtr = cmd[1].equals("1") || Boolean.parseBoolean(cmd[1]);
            this.log.info((Object)("setting DTR to " + (this.dtr ? "1" : "0")));
            this.port.setDTR(this.dtr);
            return;
        }
        if (cmd[0].equals("rts") && cmd.length == 2) {
            this.rts = cmd[1].equals("1") || Boolean.parseBoolean(cmd[1]);
            this.log.info((Object)("setting RTS to " + (this.rts ? "1" : "0")));
            this.port.setRTS(this.rts);
            return;
        }
        this.log.error((Object)("unknown command `" + cmd[0] + "'"));
    }

    @Override
    public void serialEvent(SerialPortEvent event) {
        if (event.getEventType() != 1) {
            this.log.info((Object)("rec'd serial port event " + Client.decodeSerialEvent(event)));
        }
        if (!this.useThread) {
            while (true) {
                block6: {
                    try {
                        if (this.port.getInputStream().available() <= 0) {
                            break;
                        }
                    }
                    catch (IOException e) {
                        if (this.done) break block6;
                        this.log.error((Object)("exception while reading: " + e));
                        this.done = true;
                    }
                }
                this.readData();
            }
        }
    }

    private void readData() {
        int r;
        byte[] buf = new byte[8192];
        try {
            r = this.port.getInputStream().read(buf);
        }
        catch (IOException e) {
            if (!this.done) {
                this.log.error((Object)("exception while reading: " + e));
                this.done = true;
            }
            return;
        }
        if (r == -1) {
            if (!this.done) {
                this.log.error((Object)"read EOF from stream");
                this.done = true;
            }
            return;
        }
        char[] cbuf = new char[r];
        for (int i = 0; i < r; ++i) {
            cbuf[i] = (char)(buf[i] & 0xFF);
        }
        String s = new String(cbuf);
        if (this.logInput) {
            s = s.replaceAll("\n", "\\n").replaceAll("\r", "\\r").replaceAll("\t", "\\t");
            this.log.info((Object)("RECV: [" + s + "]"));
        } else {
            System.out.print(s);
            System.out.flush();
        }
    }

    public static String decodeSerialEvent(SerialPortEvent event) {
        String name;
        switch (event.getEventType()) {
            case 10: {
                name = "BREAK";
                break;
            }
            case 6: {
                name = "CARRIER-DETECT";
                break;
            }
            case 3: {
                name = "CTS";
                break;
            }
            case 1: {
                name = "DATA_AVAILABLE";
                break;
            }
            case 4: {
                name = "DSR";
                break;
            }
            case 9: {
                name = "FRAMING-ERROR";
                break;
            }
            case 7: {
                name = "OVERFLOW-ERROR";
                break;
            }
            case 2: {
                name = "OUTPUT-BUFFER-EMPTY";
                break;
            }
            case 8: {
                name = "PARITY-ERROR";
                break;
            }
            case 5: {
                name = "RING-INDICATION";
                break;
            }
            default: {
                name = "?" + event.getEventType() + "?";
            }
        }
        String oldValue = event.getOldValue() ? "0" : "1";
        String newValue = event.getNewValue() ? "0" : "1";
        return name + " " + oldValue + " -> " + newValue;
    }
}

