/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.jvser;

import org.dellroad.jvser.ComPortCommand;
import org.dellroad.jvser.ComPortCommandSwitch;

public class ParityCommand
extends ComPortCommand {
    private int parity;

    public ParityCommand(int[] bytes) {
        super("SET-PARITY", 3, bytes);
        this.parity = bytes[2];
        switch (this.parity) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid parity value " + this.parity);
            }
        }
    }

    public ParityCommand(boolean client, int parity) {
        this(new int[]{44, client ? 3 : 103, parity});
    }

    @Override
    public String toString() {
        String desc;
        switch (this.parity) {
            case 0: {
                desc = "REQUEST";
                break;
            }
            case 1: {
                desc = "NONE";
                break;
            }
            case 2: {
                desc = "ODD";
                break;
            }
            case 3: {
                desc = "EVEN";
                break;
            }
            case 4: {
                desc = "MARK";
                break;
            }
            case 5: {
                desc = "SPACE";
                break;
            }
            default: {
                desc = "?";
            }
        }
        return this.getName() + " " + desc;
    }

    @Override
    public void visit(ComPortCommandSwitch sw) {
        sw.caseParity(this);
    }

    public int getParity() {
        return this.parity;
    }

    @Override
    int getMinPayloadLength() {
        return 1;
    }

    @Override
    int getMaxPayloadLength() {
        return 1;
    }
}

