/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.jvser;

import org.dellroad.jvser.ComPortCommand;
import org.dellroad.jvser.ComPortCommandSwitch;

public class DataSizeCommand
extends ComPortCommand {
    private int dataSize;

    public DataSizeCommand(int[] bytes) {
        super("SET-DATASIZE", 2, bytes);
        this.dataSize = bytes[2];
        switch (this.dataSize) {
            case 0: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid data size value " + this.dataSize);
            }
        }
    }

    public DataSizeCommand(boolean client, int dataSize) {
        this(new int[]{44, client ? 2 : 102, dataSize});
    }

    @Override
    public String toString() {
        String desc;
        switch (this.dataSize) {
            case 0: {
                desc = "REQUEST";
                break;
            }
            case 5: {
                desc = "5";
                break;
            }
            case 6: {
                desc = "6";
                break;
            }
            case 7: {
                desc = "7";
                break;
            }
            case 8: {
                desc = "8";
                break;
            }
            default: {
                desc = "?";
            }
        }
        return this.getName() + " " + desc;
    }

    @Override
    public void visit(ComPortCommandSwitch sw) {
        sw.caseDataSize(this);
    }

    public int getDataSize() {
        return this.dataSize;
    }

    @Override
    int getMinPayloadLength() {
        return 1;
    }

    @Override
    int getMaxPayloadLength() {
        return 1;
    }
}

