/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.jvser;

import org.dellroad.jvser.BaudRateCommand;
import org.dellroad.jvser.ComPortCommand;
import org.dellroad.jvser.ControlCommand;
import org.dellroad.jvser.DataSizeCommand;
import org.dellroad.jvser.FlowControlResumeCommand;
import org.dellroad.jvser.FlowControlSuspendCommand;
import org.dellroad.jvser.LineStateMaskCommand;
import org.dellroad.jvser.ModemStateMaskCommand;
import org.dellroad.jvser.NotifyLineStateCommand;
import org.dellroad.jvser.NotifyModemStateCommand;
import org.dellroad.jvser.ParityCommand;
import org.dellroad.jvser.PurgeDataCommand;
import org.dellroad.jvser.SignatureCommand;
import org.dellroad.jvser.StopSizeCommand;

public final class RFC2217 {
    public static final int COM_PORT_OPTION = 44;
    public static final int SIGNATURE = 0;
    public static final int SET_BAUDRATE = 1;
    public static final int SET_DATASIZE = 2;
    public static final int SET_PARITY = 3;
    public static final int SET_STOPSIZE = 4;
    public static final int SET_CONTROL = 5;
    public static final int NOTIFY_LINESTATE = 6;
    public static final int NOTIFY_MODEMSTATE = 7;
    public static final int FLOWCONTROL_SUSPEND = 8;
    public static final int FLOWCONTROL_RESUME = 9;
    public static final int SET_LINESTATE_MASK = 10;
    public static final int SET_MODEMSTATE_MASK = 11;
    public static final int PURGE_DATA = 12;
    public static final int SERVER_OFFSET = 100;
    public static final int DATASIZE_REQUEST = 0;
    public static final int DATASIZE_5 = 5;
    public static final int DATASIZE_6 = 6;
    public static final int DATASIZE_7 = 7;
    public static final int DATASIZE_8 = 8;
    public static final int PARITY_REQUEST = 0;
    public static final int PARITY_NONE = 1;
    public static final int PARITY_ODD = 2;
    public static final int PARITY_EVEN = 3;
    public static final int PARITY_MARK = 4;
    public static final int PARITY_SPACE = 5;
    public static final int STOPSIZE_REQUEST = 0;
    public static final int STOPSIZE_1 = 1;
    public static final int STOPSIZE_2 = 2;
    public static final int STOPSIZE_1_5 = 3;
    public static final int CONTROL_OUTBOUND_FLOW_REQUEST = 0;
    public static final int CONTROL_OUTBOUND_FLOW_NONE = 1;
    public static final int CONTROL_OUTBOUND_FLOW_XON_XOFF = 2;
    public static final int CONTROL_OUTBOUND_FLOW_HARDWARE = 3;
    public static final int CONTROL_BREAK_REQUEST = 4;
    public static final int CONTROL_BREAK_ON = 5;
    public static final int CONTROL_BREAK_OFF = 6;
    public static final int CONTROL_DTR_REQUEST = 7;
    public static final int CONTROL_DTR_ON = 8;
    public static final int CONTROL_DTR_OFF = 9;
    public static final int CONTROL_RTS_REQUEST = 10;
    public static final int CONTROL_RTS_ON = 11;
    public static final int CONTROL_RTS_OFF = 12;
    public static final int CONTROL_INBOUND_FLOW_REQUEST = 13;
    public static final int CONTROL_INBOUND_FLOW_NONE = 14;
    public static final int CONTROL_INBOUND_FLOW_XON_XOFF = 15;
    public static final int CONTROL_INBOUND_FLOW_HARDWARE = 16;
    public static final int CONTROL_OUTBOUND_FLOW_DCD = 17;
    public static final int CONTROL_INBOUND_FLOW_DTR = 18;
    public static final int CONTROL_OUTBOUND_FLOW_DSR = 19;
    public static final int LINESTATE_TIME_OUT = 128;
    public static final int LINESTATE_TRANSFER_SHIFT_REGISTER_EMPTY = 64;
    public static final int LINESTATE_TRANSFER_HOLDING_REGISTER_EMPTY = 32;
    public static final int LINESTATE_BREAK_DETECT = 16;
    public static final int LINESTATE_FRAMING_ERROR = 8;
    public static final int LINESTATE_PARITY_ERROR = 4;
    public static final int LINESTATE_OVERRUN_ERROR = 2;
    public static final int LINESTATE_DATA_READY = 1;
    public static final int MODEMSTATE_CARRIER_DETECT = 128;
    public static final int MODEMSTATE_RING_INDICATOR = 64;
    public static final int MODEMSTATE_DSR = 32;
    public static final int MODEMSTATE_CTS = 16;
    public static final int MODEMSTATE_DELTA_CARRIER_DETECT = 8;
    public static final int MODEMSTATE_TRAILING_EDGE_RING_DETECTOR = 4;
    public static final int MODEMSTATE_DELTA_DSR = 2;
    public static final int MODEMSTATE_DELTA_CTS = 1;
    public static final int PURGE_DATA_RECEIVE_DATA_BUFFER = 1;
    public static final int PURGE_DATA_TRANSMIT_DATA_BUFFER = 2;
    public static final int PURGE_DATA_BOTH_DATA_BUFFERS = 3;

    private RFC2217() {
    }

    public static ComPortCommand decodeComPortCommand(int[] bytes) {
        if (bytes.length < 2) {
            throw new IllegalArgumentException("length < 2");
        }
        if (bytes[0] != 44) {
            throw new IllegalArgumentException("not a COM-PORT-OPTION (option = " + bytes[0] + ")");
        }
        switch (bytes[1]) {
            case 0: 
            case 100: {
                return new SignatureCommand(bytes);
            }
            case 1: 
            case 101: {
                return new BaudRateCommand(bytes);
            }
            case 2: 
            case 102: {
                return new DataSizeCommand(bytes);
            }
            case 3: 
            case 103: {
                return new ParityCommand(bytes);
            }
            case 4: 
            case 104: {
                return new StopSizeCommand(bytes);
            }
            case 5: 
            case 105: {
                return new ControlCommand(bytes);
            }
            case 6: 
            case 106: {
                return new NotifyLineStateCommand(bytes);
            }
            case 7: 
            case 107: {
                return new NotifyModemStateCommand(bytes);
            }
            case 8: 
            case 108: {
                return new FlowControlSuspendCommand(bytes);
            }
            case 9: 
            case 109: {
                return new FlowControlResumeCommand(bytes);
            }
            case 10: 
            case 110: {
                return new LineStateMaskCommand(bytes);
            }
            case 11: 
            case 111: {
                return new ModemStateMaskCommand(bytes);
            }
            case 12: 
            case 112: {
                return new PurgeDataCommand(bytes);
            }
        }
        throw new IllegalArgumentException("unrecognized COM-PORT-OPTION command " + bytes[1]);
    }
}

