/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.jvser;

import java.util.Arrays;
import org.dellroad.jvser.ComPortCommandSwitch;

public abstract class ComPortCommand {
    final String name;
    final int[] bytes;

    protected ComPortCommand(String name, int command, int[] bytes) {
        this.name = name;
        int minLength = 2 + this.getMinPayloadLength();
        int maxLength = 2 + this.getMaxPayloadLength();
        if (bytes.length < minLength || bytes.length > maxLength) {
            throw new IllegalArgumentException("command " + command + " length = " + bytes.length + " is not in the range " + minLength + ".." + maxLength);
        }
        this.bytes = (int[])bytes.clone();
        if (this.bytes[0] != 44) {
            throw new IllegalArgumentException("not a COM-PORT-OPTION");
        }
        if (command >= 100) {
            throw new IllegalArgumentException("invalid command " + command);
        }
        if (this.getCommand() != command && this.getCommand() != command + 100) {
            throw new IllegalArgumentException("not a " + name + " option");
        }
    }

    public final boolean isServerCommand() {
        return this.getCommand() >= 100;
    }

    public final int[] getBytes() {
        return (int[])this.bytes.clone();
    }

    public final int getCommand() {
        return this.bytes[1] & 0xFF;
    }

    public String getName() {
        return this.name + (this.isServerCommand() ? "[S]" : "[C]");
    }

    public abstract String toString();

    public abstract void visit(ComPortCommandSwitch var1);

    byte[] getPayload() {
        byte[] buf = new byte[this.bytes.length - 2];
        for (int i = 2; i < this.bytes.length; ++i) {
            buf[i - 2] = (byte)this.bytes[i];
        }
        return buf;
    }

    abstract int getMinPayloadLength();

    abstract int getMaxPayloadLength();

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ComPortCommand that = (ComPortCommand)obj;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.bytes.length; ++i) {
            hash = hash * 37 + this.bytes[i];
        }
        return hash;
    }
}

