/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.jvser;

import org.dellroad.jvser.ComPortCommand;
import org.dellroad.jvser.ComPortCommandSwitch;

public class BaudRateCommand
extends ComPortCommand {
    private int baudRate;

    public BaudRateCommand(int[] bytes) {
        super("SET-BAUDRATE", 1, bytes);
        this.baudRate = (bytes[2] & 0xFF) << 24 | (bytes[3] & 0xFF) << 16 | (bytes[4] & 0xFF) << 8 | bytes[5] & 0xFF;
    }

    public BaudRateCommand(boolean client, int baudRate) {
        this(new int[]{44, client ? 1 : 101, baudRate >> 24 & 0xFF, baudRate >> 16 & 0xFF, baudRate >> 8 & 0xFF, baudRate & 0xFF});
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.baudRate;
    }

    @Override
    public void visit(ComPortCommandSwitch sw) {
        sw.caseBaudRate(this);
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    @Override
    int getMinPayloadLength() {
        return 4;
    }

    @Override
    int getMaxPayloadLength() {
        return 4;
    }
}

