/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nsis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.nsis.io.ProcessOutputConsumer;
import org.codehaus.mojo.nsis.io.ProcessOutputHandler;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class NsisCompileMojo
extends AbstractMojo
implements ProcessOutputConsumer {
    private String makensisBin;
    private String setupScript;
    private String outputFile;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private boolean isWindows = System.getProperty("os.name").startsWith("Windows");

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validate();
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.makensisBin);
        File targetFile = FileUtils.resolveFile((File)new File(this.project.getBuild().getDirectory()), (String)this.outputFile);
        File targetDirectory = targetFile.getParentFile();
        if (!targetDirectory.exists()) {
            try {
                FileUtils.forceMkdir((File)targetDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Can't create target directory " + targetDirectory.getAbsolutePath(), (Exception)e);
            }
        }
        String optPrefix = this.isWindows ? "/" : "-";
        commands.add(String.valueOf(optPrefix) + "X" + "OutFile " + StringUtils.quoteAndEscape((String)targetFile.getAbsolutePath(), (char)'\''));
        commands.add(String.valueOf(optPrefix) + "V2");
        commands.add(this.setupScript);
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.directory(this.project.getBasedir());
        builder.redirectErrorStream(true);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("directory:  " + builder.directory().getAbsolutePath()));
            this.getLog().debug((CharSequence)("commands  " + builder.command().toString()));
        }
        try {
            int status;
            Process process = builder.start();
            ProcessOutputHandler output = new ProcessOutputHandler(process.getInputStream(), this);
            output.startThread();
            try {
                status = process.waitFor();
            }
            catch (InterruptedException e) {
                status = process.exitValue();
            }
            output.setDone(true);
            if (status != 0) {
                throw new MojoExecutionException("Execution of makensis compiler failed. See output above for details.");
            }
            this.projectHelper.attachArtifact(this.project, "exe", null, targetFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to execute makensis", (Exception)e);
        }
    }

    public void consumeOutputLine(String line) {
        this.getLog().info((CharSequence)("[MAKENSIS] " + line));
    }

    private void validate() throws MojoFailureException {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.setupScript));
            String line = reader.readLine();
            while (line != null) {
                if (line.trim().startsWith("OutFile ")) {
                    this.getLog().warn((CharSequence)"setupScript contains the property 'OutFile'. Please move this setting to the plugin-configuration");
                }
                line = reader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

