/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding.outside;

import junit.framework.TestCase;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class ELPropertyAccessTest
extends TestCase {
    private Property valP = ELProperty.create((String)"${value}");

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private void doCheck(Object obj, boolean expectedReadable, boolean expectedWriteable, int expectedValue) {
        ELPropertyAccessTest.assertEquals((boolean)expectedReadable, (boolean)this.valP.isReadable(obj));
        if (expectedReadable) {
            ELPropertyAccessTest.assertEquals((Object)expectedValue, (Object)this.valP.getValue(obj));
        } else {
            try {
                this.valP.getValue(obj);
                ELPropertyAccessTest.fail();
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
        }
        if (!expectedWriteable) {
            try {
                this.valP.getWriteType(obj);
                ELPropertyAccessTest.fail();
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
            try {
                this.valP.setValue(obj, (Object)10);
                ELPropertyAccessTest.fail();
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
        }
    }

    public void test_Public_Reader() {
        this.doCheck(new Public_Reader(), true, false, 10);
    }

    public void test_Public_Writer() {
        this.doCheck(new Public_Writer(), false, true, -1);
    }

    public void test_Public_ReaderWriter() {
        this.doCheck(new Public_ReaderWriter(), true, true, 10);
    }

    public void test_Private_ReaderWriter() {
        this.doCheck(new Private_ReaderWriter(), false, false, -1);
    }

    public void test_Private_Extends_Public_Reader() {
        this.doCheck(new Private_Extends_Public_Reader(), true, false, 10);
    }

    public void test_Private_Extends_Public_Writer() {
        this.doCheck(new Private_Extends_Public_Writer(), false, true, -1);
    }

    public void test_Private_Extends_Public_ReaderWriter() {
        this.doCheck(new Private_Extends_Public_ReaderWriter(), true, true, 20);
    }

    private class Private_Extends_Public_ReaderWriter
    extends Public_ReaderWriter {
        private Private_Extends_Public_ReaderWriter() {
        }

        public int getValue() {
            return 20;
        }
    }

    private class Private_Extends_Public_Writer
    extends Public_Writer {
        private Private_Extends_Public_Writer() {
        }
    }

    private class Private_Extends_Public_Reader
    extends Public_Reader {
        private Private_Extends_Public_Reader() {
        }
    }

    private class Private_ReaderWriter {
        private Private_ReaderWriter() {
        }

        public int getValue() {
            return 10;
        }

        public void setValue(int value) {
        }
    }

    public class Public_ReaderWriter {
        public int getValue() {
            return 10;
        }

        public void setValue(int value) {
        }
    }

    public class Public_Writer {
        public void setValue(int value) {
        }
    }

    public class Public_Reader {
        public int getValue() {
            return 10;
        }
    }
}

