/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding.outside;

import junit.framework.TestCase;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Property;

public class BeanPropertyAccessTest
extends TestCase {
    private Property valP = BeanProperty.create((String)"value");

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private void doCheck(Object obj, boolean expectedReadable, boolean expectedWriteable, int expectedValue) {
        BeanPropertyAccessTest.assertEquals((boolean)expectedReadable, (boolean)this.valP.isReadable(obj));
        BeanPropertyAccessTest.assertEquals((boolean)expectedWriteable, (boolean)this.valP.isWriteable(obj));
        if (expectedReadable) {
            BeanPropertyAccessTest.assertEquals((Object)expectedValue, (Object)this.valP.getValue(obj));
        } else {
            try {
                this.valP.getValue(obj);
                BeanPropertyAccessTest.fail();
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
        }
        if (expectedWriteable) {
            BeanPropertyAccessTest.assertEquals(Integer.TYPE, (Object)this.valP.getWriteType(obj));
            this.valP.setValue(obj, (Object)10);
        } else {
            try {
                this.valP.getWriteType(obj);
                BeanPropertyAccessTest.fail();
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
            try {
                this.valP.setValue(obj, (Object)10);
                BeanPropertyAccessTest.fail();
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
        }
    }

    public void test_Public_Reader() {
        this.doCheck(new Public_Reader(), true, false, 10);
    }

    public void test_Public_Writer() {
        this.doCheck(new Public_Writer(), false, true, -1);
    }

    public void test_Public_ReaderWriter() {
        this.doCheck(new Public_ReaderWriter(), true, true, 10);
    }

    public void test_Private_ReaderWriter() {
        this.doCheck(new Private_ReaderWriter(), false, false, -1);
    }

    public void test_Private_Extends_Public_Reader() {
        this.doCheck(new Private_Extends_Public_Reader(), true, false, 10);
    }

    public void test_Private_Extends_Public_Writer() {
        this.doCheck(new Private_Extends_Public_Writer(), false, true, -1);
    }

    public void test_Private_Extends_Public_ReaderWriter() {
        this.doCheck(new Private_Extends_Public_ReaderWriter(), true, true, 20);
    }

    private class Private_Extends_Public_ReaderWriter
    extends Public_ReaderWriter {
        private Private_Extends_Public_ReaderWriter() {
        }

        public int getValue() {
            return 20;
        }
    }

    private class Private_Extends_Public_Writer
    extends Public_Writer {
        private Private_Extends_Public_Writer() {
        }
    }

    private class Private_Extends_Public_Reader
    extends Public_Reader {
        private Private_Extends_Public_Reader() {
        }
    }

    private class Private_ReaderWriter {
        private Private_ReaderWriter() {
        }

        public int getValue() {
            return 10;
        }

        public void setValue(int value) {
        }
    }

    public class Public_ReaderWriter {
        public int getValue() {
            return 10;
        }

        public void setValue(int value) {
        }
    }

    public class Public_Writer {
        public void setValue(int value) {
        }
    }

    public class Public_Reader {
        public int getValue() {
            return 10;
        }
    }
}

