/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding;

import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.TestSupport;
import org.jdesktop.beansbinding.timing.StopWatch;
import org.jdesktop.beansbinding.util.logging.Logger;
import org.junit.Test;

public class PropertyPerformanceTest
extends TestSupport {
    private static final String CLASS = PropertyPerformanceTest.class.getName();
    private static final Logger logger = Logger.getLogger((String)CLASS);

    @Test
    public void testPerformance() throws Exception {
        logger.info("testPerformance()", new Object[0]);
        System.err.println("XXXX " + System.getProperties());
        double limit = 10000.0;
        int iterations = 50000;
        long warmupTime = 10000L;
        TestBean bean = new TestBean();
        BeanProperty valueProperty = BeanProperty.create((String)"value");
        StopWatch stopWatch = new StopWatch();
        long time = System.currentTimeMillis();
        logger.info(">>>> warming up...", new Object[0]);
        while (System.currentTimeMillis() - time < 10000L) {
            valueProperty.getValue((Object)bean);
        }
        logger.info(">>>> testing...", new Object[0]);
        stopWatch.start();
        for (int i = 0; i < 50000; ++i) {
            valueProperty.getValue((Object)bean);
        }
        stopWatch.stop();
        logger.info(">>>> %s", new Object[]{stopWatch});
        long cpuTime = stopWatch.getCurrentThreadCpuTime();
        double cpuTimePerIteration = 1.0 * (double)cpuTime / 50000.0;
        logger.info(">>>> totalCpuTime: %fms, cpuTimePerIteration: %f\u00b5s", new Object[]{(double)cpuTime / 1000000.0, cpuTimePerIteration / 1000.0});
        if (cpuTimePerIteration > limit) {
            logger.warning("Time per iteration (%f\u00b5s) is longer than allowed (%f\u00b5s)", new Object[]{cpuTimePerIteration / 1000.0, limit / 1000.0});
        }
    }

    public static class TestBean {
        public String getValue() {
            return "value";
        }
    }
}

