/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding.timing;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.junit.Assert;

public class StopWatch {
    private final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private long threadCpuTimeBaseTime = 0L;
    private long threadCpuTimeAccumulator = 0L;
    private long elapsedTimeBaseTime = 0L;
    private long elapsedTimeAccumulator = 0L;
    private double calibrationFactor = 1.0;

    public StopWatch() {
        Assert.assertTrue((String)"isThreadCpuTimeEnabled == false", (boolean)this.threadBean.isThreadCpuTimeEnabled());
        Assert.assertTrue((String)"isThreadCpuTimeSupported == false", (boolean)this.threadBean.isThreadCpuTimeSupported());
        Assert.assertTrue((String)"isCurrentThreadCpuTimeSupported == false", (boolean)this.threadBean.isCurrentThreadCpuTimeSupported());
        this.calibrate();
    }

    public void start() {
        this.elapsedTimeAccumulator = 0L;
        this.threadCpuTimeAccumulator = 0L;
        this.resume();
    }

    public void stop() {
        this.pause();
    }

    public void pause() {
        this.elapsedTimeAccumulator += System.currentTimeMillis() - this.elapsedTimeBaseTime;
        this.threadCpuTimeAccumulator += this.threadBean.getCurrentThreadCpuTime() - this.threadCpuTimeBaseTime;
    }

    public void resume() {
        this.elapsedTimeBaseTime = System.currentTimeMillis();
        this.threadCpuTimeBaseTime = this.threadBean.getCurrentThreadCpuTime();
    }

    public long getElapsedTime() {
        return this.elapsedTimeAccumulator * 1000000L;
    }

    public long getCurrentThreadCpuTime() {
        return this.threadCpuTimeAccumulator;
    }

    public String toString() {
        return String.format("StopWatch[elapsedTime: %dms, threadCpuTime: %fms calibrationFactor: %f]", this.elapsedTimeAccumulator, (double)this.threadCpuTimeAccumulator / 1000000.0, this.calibrationFactor);
    }

    private void calibrate() {
        long base = this.threadBean.getCurrentThreadCpuTime();
        int n = 0;
        for (int i = 0; i < 100000000; ++i) {
            n += i;
        }
        this.calibrationFactor = (double)(this.threadBean.getCurrentThreadCpuTime() - base) / 2.365E7;
    }
}

