/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.TestSupport;
import org.jdesktop.beansbinding.Validator;
import org.junit.Assert;
import org.junit.Test;

public class BindingTest
extends TestSupport {
    private static final String PROP_NAME = "someProperty";
    private static final String OBJ_PROP_NAME = "objProperty";
    private static final String MYSTERY_PROP_NAME = "mystery";
    private static final String PROP_VALUE = "PropertyValue";
    private static final String PROP_NEW_VALUE = "NewPropertyValue";
    private static final Property stringProperty = BeanProperty.create((String)"someProperty");
    private static final Property bogusProperty = BeanProperty.create((String)"bogus!");
    private static final Property objectProperty = BeanProperty.create((String)"objProperty");
    private static final Property mysteryProperty = BeanProperty.create((String)"mystery");

    @Test
    public void testPrintln() {
        Object source = new Object();
        BeanProperty classProp = BeanProperty.create((String)"class");
        Object target = new Object();
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_ONCE, (Object)source, (Property)classProp, (Object)target, (Property)classProp);
        System.out.println("Testing toString() (unbound):\n" + binding);
        binding.bind();
        System.out.println("Testing toString() (bound):\n" + binding);
    }

    @Test
    public void testIsSourceUnreadableValueSet() {
        Binding binding = BindingTest.createTestBinding();
        Assert.assertFalse((boolean)binding.isSourceUnreadableValueSet());
        binding.setSourceUnreadableValue(new Object());
        Assert.assertTrue((boolean)binding.isSourceUnreadableValueSet());
        binding.unsetSourceUnreadableValue();
        Assert.assertFalse((boolean)binding.isSourceUnreadableValueSet());
        binding.bind();
        boolean b = binding.isSourceUnreadableValueSet();
    }

    @Test
    public void testUnsetSourceUnreadableValue() {
        Binding binding = BindingTest.createTestBinding();
        SourceUnreadableListener pcl = new SourceUnreadableListener();
        binding.addPropertyChangeListener((PropertyChangeListener)pcl);
        binding.unsetSourceUnreadableValue();
        Assert.assertFalse((boolean)binding.isSourceUnreadableValueSet());
        Assert.assertFalse((boolean)pcl.valueSetBecameFalse);
        Assert.assertFalse((boolean)pcl.valueSetBecameTrue);
        binding.setSourceUnreadableValue(new Object());
        pcl.init();
        binding.unsetSourceUnreadableValue();
        Assert.assertFalse((boolean)binding.isSourceUnreadableValueSet());
        Assert.assertTrue((boolean)pcl.valueSetBecameFalse);
        Assert.assertTrue((pcl.newValue == null ? 1 : 0) != 0);
        binding.setSourceUnreadableValue(new Object());
        binding.bind();
        boolean caught = false;
        try {
            binding.unsetSourceUnreadableValue();
        }
        catch (IllegalStateException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
    }

    @Test
    public void testgetSourceUnreadableValue() {
        Binding binding = BindingTest.createTestBinding();
        boolean caught = false;
        try {
            Object o = binding.getSourceUnreadableValue();
        }
        catch (UnsupportedOperationException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
    }

    @Test
    public void testSetSourceUnreadableValue() {
        Binding binding = BindingTest.createTestBinding();
        SourceUnreadableListener pcl = new SourceUnreadableListener();
        binding.addPropertyChangeListener((PropertyChangeListener)pcl);
        binding.setSourceUnreadableValue(null);
        Assert.assertTrue((boolean)binding.isSourceUnreadableValueSet());
        Assert.assertTrue((binding.getSourceUnreadableValue() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pcl.valueSetBecameTrue);
        Assert.assertTrue((pcl.newValue == null ? 1 : 0) != 0);
        pcl.init();
        Object value = new Object();
        binding.setSourceUnreadableValue(value);
        Assert.assertTrue((boolean)binding.isSourceUnreadableValueSet());
        Assert.assertTrue((binding.getSourceUnreadableValue() == value ? 1 : 0) != 0);
        Assert.assertFalse((boolean)pcl.valueSetBecameTrue);
        Assert.assertTrue((pcl.newValue == value ? 1 : 0) != 0);
        binding.unsetSourceUnreadableValue();
        binding.bind();
        boolean caught = false;
        try {
            binding.setSourceUnreadableValue(new Object());
        }
        catch (IllegalStateException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        Assert.assertFalse((boolean)binding.isSourceUnreadableValueSet());
    }

    @Test
    public void testGetSourceValueForTarget() {
        Binding.ValueResult retVal;
        String unreadableValue = "Unreadable!";
        TestBean source = new TestBean();
        TestBean target = new TestBean();
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)source, (Property)stringProperty, (Object)target, (Property)bogusProperty);
        Binding.ValueResult valRes = retVal = binding.getSourceValueForTarget();
        Assert.assertTrue((boolean)valRes.failed());
        Assert.assertTrue((boolean)valRes.getFailure().getType().equals((Object)Binding.SyncFailureType.TARGET_UNWRITEABLE));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)source, (Property)bogusProperty, (Object)target, (Property)stringProperty);
        binding.setSourceUnreadableValue((Object)unreadableValue);
        Assert.assertTrue((boolean)binding.isSourceUnreadableValueSet());
        valRes = retVal = binding.getSourceValueForTarget();
        Object valResVal = valRes.getValue();
        Assert.assertTrue((valResVal == unreadableValue ? 1 : 0) != 0);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)source, (Property)bogusProperty, (Object)target, (Property)stringProperty);
        Assert.assertFalse((boolean)binding.isSourceUnreadableValueSet());
        valRes = retVal = binding.getSourceValueForTarget();
        Assert.assertTrue((boolean)valRes.failed());
        Assert.assertTrue((boolean)valRes.getFailure().getType().equals((Object)Binding.SyncFailureType.SOURCE_UNREADABLE));
        source = new TestBean();
        source.setSomeProperty(null);
        target = new TestBean();
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)source, (Property)stringProperty, (Object)target, (Property)stringProperty);
        valRes = retVal = binding.getSourceValueForTarget();
        Assert.assertTrue((valRes.getValue() == null ? 1 : 0) != 0);
        Object sourceNullValue = new Object();
        binding.setSourceNullValue(sourceNullValue);
        valRes = retVal = binding.getSourceValueForTarget();
        Assert.assertTrue((valRes.getValue() == sourceNullValue ? 1 : 0) != 0);
        source = new TestBean();
        target = new TestBean();
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)source, (Property)stringProperty, (Object)target, (Property)stringProperty);
        ObjStringConverter converter = new ObjStringConverter();
        binding.setConverter((Converter)converter);
        boolean caught = false;
        converter.shouldThrow = true;
        try {
            retVal = binding.getSourceValueForTarget();
        }
        catch (RuntimeException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        caught = false;
        converter.init();
        converter.shouldThrowCCE = true;
        try {
            retVal = binding.getSourceValueForTarget();
        }
        catch (ClassCastException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        converter.init();
        valRes = retVal = binding.getSourceValueForTarget();
        Assert.assertFalse((boolean)valRes.failed());
        Assert.assertTrue((boolean)converter.forwardCalled);
        Assert.assertTrue((boolean)ObjStringConverter.wasConverted(valRes.getValue()));
        source = new TestBean();
        source.setObjProperty(new Integer(42));
        target = new TestBean();
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)source, (Property)objectProperty, (Object)target, (Property)stringProperty);
        valRes = retVal = binding.getSourceValueForTarget();
        Assert.assertFalse((boolean)valRes.failed());
        Assert.assertTrue((boolean)valRes.getValue().getClass().equals(stringProperty.getWriteType((Object)target)));
        source = new TestBean();
        target = new TestBean();
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)source, (Property)stringProperty, (Object)target, (Property)mysteryProperty);
        caught = false;
        try {
            retVal = binding.getSourceValueForTarget();
        }
        catch (ClassCastException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
    }

    @Test
    public void testGetTargetValueForSource() {
        Binding.ValueResult retVal;
        TestBean source = new TestBean();
        TestBean target = new TestBean();
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)source, (Property)bogusProperty, (Object)target, (Property)stringProperty);
        Binding.ValueResult valRes = retVal = binding.getTargetValueForSource();
        Assert.assertTrue((boolean)valRes.failed());
        Assert.assertTrue((boolean)valRes.getFailure().getType().equals((Object)Binding.SyncFailureType.SOURCE_UNWRITEABLE));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)source, (Property)stringProperty, (Object)target, (Property)bogusProperty);
        valRes = retVal = binding.getTargetValueForSource();
        Assert.assertTrue((boolean)valRes.failed());
        Assert.assertTrue((boolean)valRes.getFailure().getType().equals((Object)Binding.SyncFailureType.TARGET_UNREADABLE));
        source = new TestBean();
        target = new TestBean();
        target.setSomeProperty(null);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)source, (Property)stringProperty, (Object)target, (Property)stringProperty);
        valRes = retVal = binding.getTargetValueForSource();
        Assert.assertFalse((boolean)valRes.failed());
        Assert.assertTrue((valRes.getValue() == null ? 1 : 0) != 0);
        Object targetNullValue = new Object();
        binding.setTargetNullValue(targetNullValue);
        valRes = retVal = binding.getTargetValueForSource();
        Assert.assertFalse((boolean)valRes.failed());
        Assert.assertTrue((valRes.getValue() == targetNullValue ? 1 : 0) != 0);
        source = new TestBean();
        target = new TestBean();
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)source, (Property)stringProperty, (Object)target, (Property)stringProperty);
        ObjStringConverter converter = new ObjStringConverter();
        binding.setConverter((Converter)converter);
        valRes = retVal = binding.getTargetValueForSource();
        Assert.assertFalse((boolean)valRes.failed());
        Assert.assertTrue((boolean)converter.reverseCalled);
        Assert.assertTrue((boolean)ObjStringConverter.wasConverted(valRes.getValue()));
        converter.init();
        converter.shouldThrow = true;
        valRes = retVal = binding.getTargetValueForSource();
        Assert.assertTrue((boolean)valRes.failed());
        Assert.assertTrue((boolean)valRes.getFailure().getType().equals((Object)Binding.SyncFailureType.CONVERSION_FAILED));
        boolean caught = false;
        converter.init();
        converter.shouldThrowCCE = true;
        try {
            retVal = binding.getTargetValueForSource();
        }
        catch (ClassCastException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        source = new TestBean();
        target = new TestBean();
        target.setObjProperty(new Integer(42));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)source, (Property)stringProperty, (Object)target, (Property)objectProperty);
        valRes = retVal = binding.getTargetValueForSource();
        Assert.assertFalse((boolean)valRes.failed());
        Assert.assertTrue((boolean)valRes.getValue().getClass().equals(stringProperty.getWriteType((Object)source)));
        source = new TestBean();
        target = new TestBean();
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)source, (Property)mysteryProperty, (Object)target, (Property)stringProperty);
        caught = false;
        try {
            retVal = binding.getTargetValueForSource();
        }
        catch (ClassCastException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        source = new TestBean();
        target = new TestBean();
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)source, (Property)stringProperty, (Object)target, (Property)stringProperty);
        TestValidator validator = new TestValidator();
        binding.setValidator((Validator)validator);
        valRes = retVal = binding.getTargetValueForSource();
        Assert.assertFalse((boolean)valRes.failed());
        Assert.assertTrue((boolean)validator.calledValidate);
        validator.init();
        validator.invalid = true;
        valRes = retVal = binding.getTargetValueForSource();
        Assert.assertTrue((boolean)valRes.failed());
        Assert.assertTrue((boolean)validator.calledValidate);
        Assert.assertTrue((boolean)valRes.getFailure().getType().equals((Object)Binding.SyncFailureType.VALIDATION_FAILED));
        Assert.assertTrue((valRes.getFailure().getValidationResult() == validator.valResult ? 1 : 0) != 0);
    }

    private static Binding createTestBinding() {
        return BindingTest.createTestBinding("bogus", "bogus");
    }

    private static Binding createTestBinding(String srcPropName, String trgPropName) {
        TestBean source = new TestBean();
        TestBean target = new TestBean();
        BeanProperty sourceProp = BeanProperty.create((String)srcPropName);
        BeanProperty targetProp = BeanProperty.create((String)trgPropName);
        return Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_ONCE, (Object)source, (Property)sourceProp, (Object)target, (Property)targetProp);
    }

    private static class TestValidator
    extends Validator {
        boolean throwRE;
        boolean throwCCE;
        boolean invalid;
        boolean calledValidate;
        Validator.Result valResult;

        public TestValidator() {
            this.init();
        }

        public void init() {
            this.throwRE = false;
            this.throwCCE = false;
            this.invalid = false;
            this.calledValidate = false;
            this.valResult = new Validator.Result((Validator)this, (Object)"TestValidator Error Code", "TestValidator Description");
        }

        public Validator.Result validate(Object value) {
            this.calledValidate = true;
            if (this.throwRE) {
                throw new RuntimeException("from validate()");
            }
            if (this.throwCCE) {
                throw new ClassCastException("from validate()");
            }
            if (this.invalid) {
                return this.valResult;
            }
            return null;
        }
    }

    private static class ObjStringConverter
    extends Converter {
        static final String PREFIX = "CONVERTED:";
        boolean forwardCalled;
        boolean reverseCalled;
        boolean shouldThrow;
        boolean shouldThrowCCE;

        public ObjStringConverter() {
            this.init();
        }

        public void init() {
            this.forwardCalled = false;
            this.reverseCalled = false;
            this.shouldThrow = false;
            this.shouldThrowCCE = false;
        }

        public Object convertForward(Object value) {
            this.forwardCalled = true;
            if (this.shouldThrow) {
                throw new RuntimeException("Exception from convertForward()");
            }
            if (this.shouldThrowCCE) {
                throw new ClassCastException("Exception from convertForward()");
            }
            return "CONVERTED: forward: " + value.toString();
        }

        public Object convertReverse(Object value) {
            this.reverseCalled = true;
            if (this.shouldThrow) {
                throw new RuntimeException("Exception from convertReverse()");
            }
            if (this.shouldThrowCCE) {
                throw new ClassCastException("Exception from convertReverse()");
            }
            return "CONVERTED: reverse: " + value.toString();
        }

        public static boolean wasConverted(Object value) {
            if (value instanceof String) {
                return ((String)value).startsWith(PREFIX);
            }
            return false;
        }
    }

    public static class TestBean {
        String value = "PropertyValue";
        Object objVal = null;
        Mystery mystVal = null;
        PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        public String getSomeProperty() {
            return this.value;
        }

        public void setSomeProperty(String newValue) {
            String oldVal = this.value;
            this.value = newValue;
            this.pcs.firePropertyChange(BindingTest.PROP_NAME, oldVal, newValue);
        }

        public Object getObjProperty() {
            return this.objVal;
        }

        public void setObjProperty(Object newValue) {
            Object oldVal = this.objVal;
            this.objVal = newValue;
            this.pcs.firePropertyChange(BindingTest.OBJ_PROP_NAME, oldVal, newValue);
        }

        public Mystery getMystery() {
            return this.mystVal;
        }

        public void setMystery(Mystery newValue) {
            Mystery oldVal = this.mystVal;
            this.mystVal = newValue;
            this.pcs.firePropertyChange(BindingTest.MYSTERY_PROP_NAME, oldVal, newValue);
        }
    }

    private static class Mystery {
        private Mystery() {
        }
    }

    private class SourceUnreadableListener
    implements PropertyChangeListener {
        boolean valueSetBecameTrue;
        boolean valueSetBecameFalse;
        Object oldValue;
        Object newValue;

        public SourceUnreadableListener() {
            this.init();
        }

        public void init() {
            this.valueSetBecameTrue = false;
            this.valueSetBecameFalse = false;
            this.oldValue = null;
            this.newValue = null;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("sourceUnreadableValueSet")) {
                if (e.getOldValue().equals(Boolean.FALSE) && e.getNewValue().equals(Boolean.TRUE)) {
                    this.valueSetBecameTrue = true;
                } else if (e.getOldValue().equals(Boolean.TRUE) && e.getNewValue().equals(Boolean.FALSE)) {
                    this.valueSetBecameFalse = true;
                }
            } else if (e.getPropertyName().equals("sourceUnreadableValue")) {
                this.oldValue = e.getOldValue();
                this.newValue = e.getNewValue();
            }
        }
    }
}

