/*
 * Decompiled with CFR 0.152.
 */
package de.idyl.crypto.zip;

import de.idyl.crypto.zip.impl.AESEncrypterBC;
import de.idyl.crypto.zip.impl.ExtZipEntry;
import de.idyl.crypto.zip.impl.ExtZipOutputStream;
import de.idyl.crypto.zip.impl.ZipFileEntryInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class AesZipFileEncrypter {
    private static final Logger LOG = Logger.getLogger(AesZipFileEncrypter.class.getName());
    protected ExtZipOutputStream zipOS;

    public AesZipFileEncrypter(String pathName) throws IOException {
        this.zipOS = new ExtZipOutputStream(new File(pathName));
    }

    public AesZipFileEncrypter(File outFile) throws IOException {
        this.zipOS = new ExtZipOutputStream(outFile);
    }

    public AesZipFileEncrypter(OutputStream outFile) throws IOException {
        this.zipOS = new ExtZipOutputStream(outFile);
    }

    protected void add(ExtZipEntry zipEntry, InputStream zipData) throws IOException, UnsupportedEncodingException {
        this.zipOS.putNextEntry(zipEntry);
        byte[] data = new byte[1024];
        int read = zipData.read(data);
        while (read != -1) {
            this.zipOS.writeBytes(data, 0, read);
            read = zipData.read(data);
        }
    }

    protected void add(ZipFile inFile, String password) throws IOException, UnsupportedEncodingException {
        ZipFileEntryInputStream zfe = new ZipFileEntryInputStream(inFile.getName());
        Enumeration<? extends ZipEntry> en = inFile.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            zfe.nextEntry(ze);
            this.add(ze, zfe, password);
        }
        zfe.close();
    }

    protected void add(ZipEntry zipEntry, ZipFileEntryInputStream zipData, String password) throws IOException, UnsupportedEncodingException {
        AESEncrypterBC aesEncrypter = new AESEncrypterBC(password.getBytes("iso-8859-1"));
        ExtZipEntry entry = new ExtZipEntry(zipEntry.getName());
        entry.setMethod(zipEntry.getMethod());
        entry.setSize(zipEntry.getSize());
        entry.setCompressedSize(zipEntry.getCompressedSize() + 28L);
        entry.setTime(zipEntry.getTime());
        entry.initEncryptedEntry();
        this.zipOS.putNextEntry(entry);
        this.zipOS.writeBytes(aesEncrypter.getSalt());
        this.zipOS.writeBytes(aesEncrypter.getPwVerification());
        byte[] data = new byte[1024];
        int read = zipData.read(data);
        while (read != -1) {
            aesEncrypter.encrypt(data, read);
            this.zipOS.writeBytes(data, 0, read);
            read = zipData.read(data);
        }
        byte[] finalAuthentication = aesEncrypter.getFinalAuthentication();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("finalAuthentication=" + Arrays.toString(finalAuthentication) + " at pos=" + this.zipOS.getWritten());
        }
        this.zipOS.writeBytes(finalAuthentication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(File file, String pathForEntry, String password) throws IOException, UnsupportedEncodingException {
        FileInputStream fis = new FileInputStream(file);
        try {
            this.add(pathForEntry, fis, password);
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(File file, String password) throws IOException, UnsupportedEncodingException {
        FileInputStream fis = new FileInputStream(file);
        try {
            this.add(file.getPath(), fis, password);
        }
        finally {
            fis.close();
        }
    }

    public void add(String name, InputStream is, String password) throws IOException, UnsupportedEncodingException {
        AESEncrypterBC aesEncrypter = new AESEncrypterBC(password.getBytes("iso-8859-1"));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)bos, new Deflater(9, true), 8192);
        int read = 0;
        long inputLen = 0L;
        byte[] buf = new byte[8192];
        while ((read = is.read(buf)) > 0) {
            inputLen += (long)read;
            dos.write(buf, 0, read);
        }
        dos.close();
        byte[] data = bos.toByteArray();
        ExtZipEntry entry = new ExtZipEntry(name);
        entry.setMethod(8);
        entry.setSize(inputLen);
        entry.setCompressedSize(data.length + 28);
        entry.setTime(new Date().getTime());
        entry.initEncryptedEntry();
        this.zipOS.putNextEntry(entry);
        this.zipOS.writeBytes(aesEncrypter.getSalt());
        this.zipOS.writeBytes(aesEncrypter.getPwVerification());
        aesEncrypter.encrypt(data, data.length);
        this.zipOS.writeBytes(data, 0, data.length);
        byte[] finalAuthentication = aesEncrypter.getFinalAuthentication();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("finalAuthentication=" + Arrays.toString(finalAuthentication) + " at pos=" + this.zipOS.getWritten());
        }
        this.zipOS.writeBytes(finalAuthentication);
    }

    public static void zip(File inFile, File outFile) throws IOException {
        int len;
        FileInputStream fin = new FileInputStream(inFile);
        FileOutputStream fout = new FileOutputStream(outFile);
        ZipOutputStream zout = new ZipOutputStream(fout);
        zout.putNextEntry(new ZipEntry(inFile.getName()));
        byte[] buffer = new byte[1024];
        while ((len = fin.read(buffer)) > 0) {
            zout.write(buffer, 0, len);
        }
        zout.closeEntry();
        zout.close();
        fin.close();
    }

    public void addAll(File pathToZipFile, String password) throws IOException {
        ZipFile zipFile = new ZipFile(pathToZipFile);
        this.add(zipFile, password);
        zipFile.close();
    }

    public void setComment(String comment) {
        this.zipOS.setComment(comment);
    }

    public void close() throws IOException {
        this.zipOS.finish();
    }

    public static void zipAndEncrypt(File inFile, File outFile, String password) throws IOException {
        AesZipFileEncrypter enc = new AesZipFileEncrypter(outFile);
        enc.add(inFile, password);
        enc.close();
    }

    public static void zipAndEncryptAll(File inZipFile, File outFile, String password) throws IOException {
        AesZipFileEncrypter enc = new AesZipFileEncrypter(outFile);
        enc.addAll(inZipFile, password);
        enc.close();
    }
}

