/*
 * Decompiled with CFR 0.152.
 */
package de.idyl.crypto.zip;

import de.idyl.crypto.zip.impl.AESDecrypterBC;
import de.idyl.crypto.zip.impl.ByteArrayHelper;
import de.idyl.crypto.zip.impl.CentralDirectoryEntry;
import de.idyl.crypto.zip.impl.ExtRandomAccessFile;
import de.idyl.crypto.zip.impl.ExtZipEntry;
import de.idyl.crypto.zip.impl.ExtZipOutputStream;
import de.idyl.crypto.zip.impl.ZipConstants;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AesZipFileDecrypter
implements ZipConstants {
    private static final Logger LOG = Logger.getLogger(AesZipFileDecrypter.class.getName());
    public static String charset = "iso-8859-1";
    protected static int bufferSize = 10240;
    protected ExtRandomAccessFile raFile;
    protected long dirOffsetPos;
    protected File zipFile;
    protected String comment;

    public AesZipFileDecrypter(File zipFile) throws IOException {
        this.zipFile = zipFile;
        this.raFile = new ExtRandomAccessFile(zipFile);
        this.initDirOffsetPosAndComment();
    }

    protected void initDirOffsetPosAndComment() throws IOException {
        this.dirOffsetPos = this.zipFile.length() - 6L;
        int dirOffset = this.raFile.readInt(this.dirOffsetPos - 16L);
        if ((long)dirOffset != 101010256L) {
            byte[] endsig = ByteArrayHelper.toByteArray(101010256);
            long endsigPos = this.raFile.lastPosOf(endsig);
            if (endsigPos == -1L) {
                throw new ZipException("expected ENDSIC not found (marks the beginning of the central directory at end of the zip file)");
            }
            this.dirOffsetPos = endsigPos + 16L;
            short commentLength = this.raFile.readShort(this.dirOffsetPos + 4L);
            this.comment = new String(this.raFile.readByteArray(this.dirOffsetPos + 6L, (int)commentLength));
        }
    }

    public void close() throws IOException {
        this.raFile.close();
    }

    public List<ExtZipEntry> getEntryList() throws IOException, ZipException {
        ArrayList<ExtZipEntry> out = new ArrayList<ExtZipEntry>();
        int totalNumberOfEntries = this.getNumberOfEntries();
        int dirOffset = this.raFile.readInt(this.dirOffsetPos);
        long fileOffset = dirOffset;
        for (int i = 0; i < totalNumberOfEntries; ++i) {
            int censig = this.raFile.readInt(fileOffset);
            if ((long)censig != 33639248L) {
                throw new ZipException("expected CENSIC not found at entry no " + (i + 1) + " in central directory at end of zip file at " + fileOffset);
            }
            short fileNameLength = this.raFile.readShort(fileOffset + 28L);
            short extraFieldLength = this.raFile.readShort(fileOffset + 30L);
            long fileOffsetPos = fileOffset + 28L + 14L;
            long fileDataOffset = this.raFile.readInt(fileOffsetPos);
            int locsig = this.raFile.readInt(fileDataOffset);
            if ((long)locsig != 67324752L) {
                throw new ZipException("expected LOCSIC not found at alleged position of data for file no " + (i + 1));
            }
            byte[] fileNameBytes = this.raFile.readByteArray(fileOffsetPos + 4L, (int)fileNameLength);
            long nextFileOffset = this.raFile.getFilePointer();
            String fileName = new String(fileNameBytes, charset);
            CentralDirectoryEntry cde = new CentralDirectoryEntry(this.raFile, fileOffset);
            ExtZipEntry zipEntry = new ExtZipEntry(fileName, cde);
            zipEntry.setCompressedSize(cde.getCompressedSize());
            zipEntry.setSize(cde.getUncompressedSize());
            long dosTime = this.raFile.readInt(fileOffset + 12L);
            zipEntry.setTime(ExtZipEntry.dosToJavaTime(dosTime));
            if (cde.isEncrypted()) {
                zipEntry.setMethod(cde.getActualCompressionMethod());
                zipEntry.setOffset((int)(cde.getLocalHeaderOffset() + (long)cde.getLocalHeaderSize()) + cde.getCryptoHeaderLength());
                zipEntry.initEncryptedEntry();
            } else {
                zipEntry.setMethod(8);
                zipEntry.setPrimaryCompressionMethod(8);
            }
            out.add(zipEntry);
            fileOffset = nextFileOffset += (long)extraFieldLength;
        }
        return out;
    }

    public ExtZipEntry getEntry(String name) throws IOException, ZipException, DataFormatException {
        for (ExtZipEntry zipEntry : this.getEntryList()) {
            if (!name.equals(zipEntry.getName())) continue;
            return zipEntry;
        }
        return null;
    }

    public void extractEntry(ExtZipEntry zipEntry, File outFile, String password) throws IOException, ZipException, DataFormatException {
        FileOutputStream fos;
        InputStream is;
        ZipFile zf;
        File tmpFile;
        if (zipEntry == null) {
            throw new ZipException("zipEntry must NOT be NULL");
        }
        if (zipEntry.isDirectory()) {
            throw new ZipException("directory entries cannot be decrypted");
        }
        if (zipEntry.isEncrypted()) {
            int len;
            byte[] pwBytes = password.getBytes(charset);
            CentralDirectoryEntry cde = zipEntry.getCentralDirectoryEntry();
            if (!cde.isAesEncrypted()) {
                throw new ZipException("only AES encrypted files are supported");
            }
            int cryptoHeaderOffset = zipEntry.getOffset() - cde.getCryptoHeaderLength();
            byte[] salt = this.raFile.readByteArray(cryptoHeaderOffset, 16);
            byte[] pwVerification = this.raFile.readByteArray(cryptoHeaderOffset + 16, 2);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("\n" + cde.toString());
                LOG.finest("offset    = " + zipEntry.getOffset());
                LOG.finest("cryptoOff = " + cryptoHeaderOffset);
                LOG.finest("pwBytes   = " + ByteArrayHelper.toString(pwBytes) + " - " + pwBytes.length);
                LOG.finest("salt      = " + ByteArrayHelper.toString(salt) + " - " + salt.length);
                LOG.finest("pwVerif   = " + ByteArrayHelper.toString(pwVerification) + " - " + pwVerification.length);
            }
            AESDecrypterBC decrypter = new AESDecrypterBC(pwBytes, salt, pwVerification);
            tmpFile = new File(outFile.getPath() + "_TMP.zip");
            AesZipFileDecrypter.makeDir(new File(tmpFile.getParent()));
            ExtZipOutputStream zos = new ExtZipOutputStream(tmpFile);
            ExtZipEntry tmpEntry = new ExtZipEntry(zipEntry);
            tmpEntry.setPrimaryCompressionMethod(zipEntry.getMethod());
            zos.putNextEntry(tmpEntry);
            this.raFile.seek(cde.getOffset());
            byte[] buffer = new byte[bufferSize];
            for (int remaining = (int)zipEntry.getEncryptedDataSize(); remaining > 0; remaining -= len) {
                len = remaining > buffer.length ? buffer.length : remaining;
                int read = this.raFile.readByteArray(buffer, len);
                decrypter.decrypt(buffer, read);
                zos.writeBytes(buffer, 0, read);
            }
            zos.finish();
            byte[] storedMac = new byte[10];
            this.raFile.readByteArray(storedMac, 10);
            byte[] calcMac = decrypter.getFinalAuthentication();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("storedMac=" + Arrays.toString(storedMac));
                LOG.fine("calcMac=" + Arrays.toString(calcMac));
            }
            if (!Arrays.equals(storedMac, calcMac)) {
                throw new ZipException("stored authentication (mac) value does not match calculated one");
            }
            zf = new ZipFile(tmpFile);
            ZipEntry ze = zf.entries().nextElement();
            is = zf.getInputStream(ze);
            fos = new FileOutputStream(outFile.getPath());
            int read = is.read(buffer);
            while (read > 0) {
                fos.write(buffer, 0, read);
                read = is.read(buffer);
            }
        } else {
            throw new ZipException("currently only extracts encrypted files - use java.util.zip to unzip");
        }
        fos.close();
        is.close();
        zf.close();
        tmpFile.delete();
    }

    public short getNumberOfEntries() throws IOException {
        return this.raFile.readShort(this.dirOffsetPos - 6L);
    }

    protected static void makeDir(File dir) {
        if (dir != null && !dir.exists()) {
            File parentDir;
            if (dir.getParent() != null && !(parentDir = new File(dir.getParent())).exists()) {
                AesZipFileDecrypter.makeDir(parentDir);
            }
            dir.mkdir();
        }
    }

    public String getComment() {
        return this.comment;
    }

    public static void main(String[] args) throws Exception {
        AesZipFileDecrypter zipFile = new AesZipFileDecrypter(new File("doc/zipSpecificationAes.zip"));
        ExtZipEntry entry = zipFile.getEntry("zipSpecification.txt");
        zipFile.extractEntry(entry, new File("doc/zipSpecification.txt"), "foo");
    }
}

