/*
 * Decompiled with CFR 0.152.
 */
package com.wisecoders.dbschema.dbf.schema;

import com.linuxense.javadbf.DBFDataType;
import com.linuxense.javadbf.DBFField;
import java.util.ArrayList;
import java.util.List;

public class Table {
    public final String name;
    public final List<DBFField> fields = new ArrayList<DBFField>();

    public Table(String name) {
        this.name = name;
    }

    public DBFField createDBFField(String name, String type, int length, int decimal) {
        DBFField field = new DBFField();
        if (name.length() > 10) {
            name = name.substring(0, 10);
        }
        field.setName(name.toUpperCase());
        switch (type.toLowerCase()) {
            case "double": 
            case "decimal": {
                field.setType(DBFDataType.NUMERIC);
                field.setLength(length);
                field.setDecimalCount(decimal);
                break;
            }
            case "float": {
                field.setType(DBFDataType.FLOATING_POINT);
                break;
            }
            case "int": {
                field.setType(DBFDataType.AUTOINCREMENT);
                break;
            }
            case "bigint": {
                field.setType(DBFDataType.NUMERIC);
                break;
            }
            case "boolean": {
                field.setType(DBFDataType.LOGICAL);
                break;
            }
            case "date": {
                field.setType(DBFDataType.DATE);
                break;
            }
            case "bit": {
                field.setType(DBFDataType.NULL_FLAGS);
                break;
            }
            case "longvarchar": {
                field.setType(DBFDataType.MEMO);
                break;
            }
            case "timestamp": {
                field.setType(DBFDataType.TIMESTAMP);
                break;
            }
            case "timestampwithtimezone": {
                field.setType(DBFDataType.TIMESTAMP_DBASE7);
                break;
            }
            case "character": {
                field.setType(DBFDataType.CHARACTER);
                field.setLength(length);
                break;
            }
            default: {
                field.setType(DBFDataType.CHARACTER);
                field.setLength(Math.min(length, 254));
            }
        }
        this.fields.add(field);
        return field;
    }

    public DBFField[] getDBFFields() {
        return this.fields.toArray(new DBFField[0]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name).append("(\n");
        for (DBFField field : this.fields) {
            sb.append(field.getName().toUpperCase()).append(" ").append(field.getType()).append(" (").append(field.getLength()).append(", ").append(field.getDecimalCount()).append(" ) ").append(field.isNullable() ? "" : "NOT NULL ").append("\n");
        }
        sb.append(")");
        return sb.toString();
    }
}

