/*
 * Decompiled with CFR 0.152.
 */
package com.wisecoders.dbschema.dbf.schema;

import com.linuxense.javadbf.DBFField;

public class DataTypeUtil {
    public static int getJavaType(DBFField field) {
        switch (field.getType()) {
            case UNKNOWN: {
                return 1111;
            }
            case VARBINARY: 
            case BLOB: 
            case GENERAL_OLE: {
                return 2004;
            }
            case NUMERIC: {
                return 3;
            }
            case LONG: {
                return 3;
            }
            case AUTOINCREMENT: {
                return 4;
            }
            case CURRENCY: {
                return 1111;
            }
            case TIMESTAMP: {
                return 93;
            }
            case TIMESTAMP_DBASE7: {
                return 2014;
            }
            case NULL_FLAGS: {
                return 0;
            }
            case DOUBLE: {
                return 3;
            }
            case FLOATING_POINT: {
                return 6;
            }
            case CHARACTER: {
                return 1;
            }
            case LOGICAL: {
                return 16;
            }
            case DATE: {
                return 91;
            }
            case MEMO: {
                return -16;
            }
            case PICTURE: 
            case BINARY: {
                return -2;
            }
            case VARCHAR: {
                return 12;
            }
        }
        return 12;
    }

    public static String getH2Type(DBFField field) {
        switch (field.getType()) {
            case DOUBLE: 
            case BINARY: {
                return "double";
            }
            case FLOATING_POINT: {
                return "float";
            }
            case CHARACTER: {
                return "char(" + field.getLength() + ")";
            }
            case LOGICAL: {
                return "boolean";
            }
            case DATE: {
                return "date";
            }
            case MEMO: {
                return "longvarchar(1048575)";
            }
            case VARCHAR: {
                return "varchar(" + field.getLength() + ")";
            }
            case UNKNOWN: 
            case BLOB: 
            case GENERAL_OLE: 
            case PICTURE: {
                return "binary";
            }
            case VARBINARY: 
            case NUMERIC: {
                return "decimal(" + (field.getLength() + field.getDecimalCount()) + "," + field.getDecimalCount() + ")";
            }
            case LONG: {
                return "bigint";
            }
            case AUTOINCREMENT: 
            case CURRENCY: {
                return "bigint";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case TIMESTAMP_DBASE7: {
                return "timestampwithtimezone";
            }
            case NULL_FLAGS: {
                return "bit";
            }
        }
        return "varchar(2147483647)";
    }

    public static boolean isH2SystemTable(String tableName) {
        return "dbs_meta_columns".equalsIgnoreCase(tableName) || "dbs_meta_files".equalsIgnoreCase(tableName);
    }
}

