/*
 * Decompiled with CFR 0.152.
 */
package com.wisecoders.dbschema.dbf.io;

import com.linuxense.javadbf.DBFWriter;
import com.wisecoders.dbschema.dbf.JdbcDriver;
import com.wisecoders.dbschema.dbf.io.H2Loader;
import com.wisecoders.dbschema.dbf.schema.DataTypeUtil;
import com.wisecoders.dbschema.dbf.schema.Db;
import com.wisecoders.dbschema.dbf.schema.Table;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class H2Writer {
    public H2Writer(Connection h2Connection, File outputFolder, String charset) throws Exception {
        Db db = new Db();
        ResultSet rsColumns = h2Connection.getMetaData().getColumns(null, null, null, null);
        while (rsColumns.next()) {
            String schemaName = rsColumns.getString(2);
            String tableName = rsColumns.getString(3);
            if ("INFORMATION_SCHEMA".equalsIgnoreCase(schemaName) || DataTypeUtil.isH2SystemTable(tableName)) continue;
            String columnName = rsColumns.getString(4);
            db.getOrCreateTable(tableName).createDBFField(columnName, rsColumns.getString(6), rsColumns.getInt(7), rsColumns.getInt(9));
        }
        for (Table table : db.getTables()) {
            File outputFile = new File(outputFolder.toURI().resolve(table.name + ".dbf"));
            JdbcDriver.LOGGER.info("Saving " + table);
            FileOutputStream os = new FileOutputStream(outputFile);
            DBFWriter writer = charset != null ? new DBFWriter((OutputStream)os, Charset.forName(charset)) : new DBFWriter((OutputStream)os);
            writer.setFields(table.getDBFFields());
            Statement st = h2Connection.createStatement();
            Throwable throwable = null;
            try {
                ResultSet rs = st.executeQuery("SELECT * FROM " + table.name);
                int recCount = 0;
                while (rs.next()) {
                    int columnCount = rs.getMetaData().getColumnCount();
                    Object[] data = new Object[columnCount];
                    for (int i = 0; i < columnCount; ++i) {
                        data[i] = rs.getObject(i + 1);
                    }
                    try {
                        writer.addRecord(data);
                    }
                    catch (Throwable ex) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Error saving ").append(outputFile.getAbsolutePath()).append(" record : [");
                        for (Object obj : data) {
                            if (obj == null) {
                                sb.append("null");
                            } else {
                                sb.append("'").append(obj.toString()).append("'");
                            }
                            sb.append(",");
                        }
                        sb.append(" ]");
                        throw new SQLException(sb.toString() + ex.getLocalizedMessage(), ex);
                    }
                    ++recCount;
                }
                rs.close();
                writer.close();
                JdbcDriver.LOGGER.info("Saved " + table.name + " " + recCount + " records.");
                H2Loader.saveFileIntoFilesMeta(table, outputFile, h2Connection);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (st == null) continue;
                if (throwable != null) {
                    try {
                        st.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                st.close();
            }
        }
    }
}

