/*
 * Decompiled with CFR 0.152.
 */
package com.wisecoders.dbschema.dbf.io;

import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFReader;
import com.wisecoders.dbschema.dbf.JdbcDriver;
import com.wisecoders.dbschema.dbf.io.DBFUtil;
import com.wisecoders.dbschema.dbf.schema.DataTypeUtil;
import com.wisecoders.dbschema.dbf.schema.Table;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;

public class H2Loader {
    private static final char QUOTE_CHAR = '\"';
    public static final String COLUMNS_META_TABLE = "dbs_meta_columns";
    private static final String INSERT_INTO_COLUMNS_META_TABLE = "insert into dbs_meta_columns( table_name, column_name, column_type, length, decimal ) values ( ?,?,?,?,? )";
    public static final String FILES_META_TABLE = "dbs_meta_files";
    private static final String CREATE_META_FILES = "CREATE TABLE IF NOT EXISTS dbs_meta_files ( file_path varchar(250) NOT NULL PRIMARY KEY, table_name varchar(2000) NOT NULL, size bigint NOT NULL, last_modified bigint NOT NULL ) ";
    private static final String CREATE_COLUMNS_META_TABLE = "create table if not exists dbs_meta_columns( table_name varchar(2000) not null, column_name varchar(2000) not null, column_type varchar(120), length int not null, decimal int not null, primary key (table_name, column_name))";
    private static final String DELETE_FROM_META_TABLE = "delete from dbs_meta_columns WHERE table_name=?";

    public static boolean isFileTransferred(File file, Connection h2Connection) throws SQLException {
        h2Connection.prepareStatement(CREATE_META_FILES).execute();
        h2Connection.commit();
        String filePath = file.getAbsolutePath();
        long fileLastModified = file.lastModified();
        long fileSize = file.length();
        try (PreparedStatement st = h2Connection.prepareStatement("SELECT size, last_modified FROM dbs_meta_files WHERE file_path=?");){
            st.setString(1, filePath);
            ResultSet rs = st.executeQuery();
            if (rs.next() && rs.getLong(1) == fileSize && rs.getLong(2) == fileLastModified) {
                JdbcDriver.LOGGER.info("File " + file.getAbsolutePath() + " is already loaded in H2.");
                boolean bl = true;
                return bl;
            }
            rs.close();
        }
        return false;
    }

    public static void saveFileIntoFilesMeta(Table table, File file, Connection h2Connection) throws SQLException {
        try (PreparedStatement st = h2Connection.prepareStatement("MERGE INTO dbs_meta_files ( file_path, table_name, size, last_modified ) KEY(file_path) VALUES ( ?, ?, ?, ? )");){
            String fileName = file.getName();
            st.setString(1, file.getAbsolutePath());
            st.setString(2, table.name);
            st.setLong(3, file.length());
            st.setLong(4, file.lastModified());
            st.executeUpdate();
        }
    }

    public static void transfer(Table table, DBFReader reader, Connection h2Connection) throws Exception {
        Object[] record;
        H2Loader.createH2MetaTable(h2Connection);
        H2Loader.deleteFromH2MetaTable(h2Connection, table);
        JdbcDriver.LOGGER.log(Level.INFO, "Transfer table '" + table.name + "' definition.");
        StringBuilder createSb = new StringBuilder("create table ").append('\"').append(table.name).append('\"').append("(\n");
        StringBuilder insertSb = new StringBuilder("insert into ").append('\"').append(table.name).append('\"').append("(");
        StringBuilder insertValuesSb = new StringBuilder("values(");
        StringBuilder logSb = new StringBuilder();
        logSb.append("Table ").append(table.name).append("\n");
        boolean appendComma = false;
        int numberOfFields = reader.getFieldCount();
        ArrayList<DBFField> dbfFieldList = new ArrayList<DBFField>();
        for (int i = 0; i < numberOfFields; ++i) {
            DBFField field = reader.getField(i);
            logSb.append("\t").append(DBFUtil.getFieldDescription(field)).append(" \n");
            H2Loader.saveFieldInMetaTable(h2Connection, table, field);
            dbfFieldList.add(field);
            if (appendComma) {
                createSb.append(",\n");
                insertSb.append(",");
                insertValuesSb.append(",");
            }
            createSb.append("\t").append('\"').append(field.getName().toLowerCase()).append('\"').append(" ");
            insertSb.append('\"').append(field.getName().toLowerCase()).append('\"');
            insertValuesSb.append("?");
            createSb.append(DataTypeUtil.getH2Type(field));
            appendComma = true;
        }
        createSb.append(")");
        insertSb.append(")");
        insertValuesSb.append(")");
        JdbcDriver.LOGGER.log(Level.INFO, "Transfer " + logSb);
        String dropTableSQL = "drop table if exists \"" + table.name + '\"';
        JdbcDriver.LOGGER.log(Level.INFO, dropTableSQL);
        h2Connection.prepareStatement(dropTableSQL).execute();
        h2Connection.commit();
        JdbcDriver.LOGGER.log(Level.INFO, createSb.toString());
        h2Connection.prepareStatement(createSb.toString()).execute();
        h2Connection.commit();
        String insertSql = insertSb.toString() + insertValuesSb.toString();
        int batchSize = Math.max(50, 500 - numberOfFields * 3);
        PreparedStatement stInsert = h2Connection.prepareStatement(insertSql);
        JdbcDriver.LOGGER.info("Transfer '" + table.name + "' data...");
        int pos = 0;
        int pendingBatch = 0;
        long _start = System.currentTimeMillis();
        while ((record = reader.nextRecord()) != null) {
            try {
                for (int i = 0; i < record.length && i < dbfFieldList.size(); ++i) {
                    Object value = record[i];
                    DBFField field = (DBFField)dbfFieldList.get(i);
                    if (value == null) {
                        stInsert.setNull(i + 1, DataTypeUtil.getJavaType(field));
                        continue;
                    }
                    stInsert.setObject(i + 1, value);
                }
            }
            catch (Exception ex) {
                JdbcDriver.LOGGER.log(Level.SEVERE, ex.toString());
                JdbcDriver.LOGGER.log(Level.SEVERE, stInsert.toString());
                throw ex;
            }
            stInsert.addBatch();
            ++pos;
            if (++pendingBatch <= batchSize) continue;
            stInsert.executeBatch();
            h2Connection.commit();
            pendingBatch = 0;
        }
        if (pendingBatch > 0) {
            stInsert.executeBatch();
        }
        h2Connection.commit();
        JdbcDriver.LOGGER.info("------- Transferred '" + table.name + "' " + pos + " records in " + (System.currentTimeMillis() - _start) + " ms");
    }

    private static void createH2MetaTable(Connection h2Connection) throws SQLException {
        Statement st = h2Connection.createStatement();
        JdbcDriver.LOGGER.log(Level.INFO, CREATE_COLUMNS_META_TABLE);
        st.execute(CREATE_COLUMNS_META_TABLE);
        st.close();
        h2Connection.commit();
    }

    private static void deleteFromH2MetaTable(Connection h2Connection, Table table) throws SQLException {
        JdbcDriver.LOGGER.log(Level.INFO, "Execute: delete from dbs_meta_columns WHERE table_name=?");
        PreparedStatement st = h2Connection.prepareStatement(DELETE_FROM_META_TABLE);
        st.setString(1, table.name);
        st.executeUpdate();
        st.close();
        h2Connection.commit();
    }

    private static void saveFieldInMetaTable(Connection h2Connection, Table table, DBFField field) throws SQLException {
        PreparedStatement st = h2Connection.prepareStatement(INSERT_INTO_COLUMNS_META_TABLE);
        st.setString(1, table.name);
        st.setString(2, field.getName().toLowerCase());
        st.setString(3, field.getType().name());
        st.setInt(4, field.getLength());
        st.setInt(5, field.getDecimalCount());
        st.execute();
        h2Connection.commit();
    }
}

