/*
 * Decompiled with CFR 0.152.
 */
package com.wisecoders.dbschema.dbf;

import com.wisecoders.dbschema.dbf.H2Connection;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.h2.Driver;
import org.h2.jdbc.JdbcConnection;

public class JdbcDriver
implements java.sql.Driver {
    private static final String PREFIX = "jdbc:dbschema:dbf:";
    private static final String H2_LOCATION = "~/.DbSchema/jdbc-dbf-cache/";
    public static final Logger LOGGER = Logger.getLogger(JdbcDriver.class.getName());
    private final List<String> h2Databases = new ArrayList<String>();

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (this.acceptsURL(PREFIX)) {
            String defaultCharset = null;
            String path = url.substring(PREFIX.length());
            int idxQuestionMark = path.indexOf(63);
            if (idxQuestionMark > 0) {
                String params = path.substring(idxQuestionMark + 1);
                path = path.substring(0, idxQuestionMark);
                for (String paramSet : params.split("&")) {
                    String[] pair = paramSet.split("=");
                    if (pair.length != 2) continue;
                    if ("log".equalsIgnoreCase(pair[0]) || "logs".equalsIgnoreCase(pair[0])) {
                        LOGGER.setLevel(Level.INFO);
                        ConsoleHandler handler = new ConsoleHandler();
                        handler.setFormatter(new SimpleFormatter());
                        LOGGER.addHandler(handler);
                        continue;
                    }
                    if (!"charset".equalsIgnoreCase(pair[0])) continue;
                    defaultCharset = pair[1];
                }
            }
            return this.getConnection(path, defaultCharset);
        }
        throw new SQLException("Incorrect URL. Expected jdbc:dbschema:dbf:<folderPath>");
    }

    private Connection getConnection(String databasePath, String defaultCharsetName) throws SQLException {
        File folder = new File(databasePath);
        if (!folder.exists()) {
            throw new SQLException("Folder does not exists: '" + folder + "'");
        }
        if (!folder.isDirectory()) {
            throw new SQLException("Expected path is not folder: '" + folder + "'");
        }
        String h2DbName = JdbcDriver.md5Java(databasePath);
        String h2DatabasePath = this.getH2DatabasePath(h2DbName);
        String h2JdbcUrl = "jdbc:h2:file:" + h2DatabasePath + ";database_to_lower=true;case_insensitive_identifiers=true";
        LOGGER.log(Level.INFO, "Create H2 database '" + h2JdbcUrl + "'");
        JdbcConnection h2NativeConnection = (JdbcConnection)new Driver().connect(h2JdbcUrl, new Properties());
        H2Connection h2Connection = new H2Connection(h2NativeConnection, defaultCharsetName);
        if (!this.h2Databases.contains(h2DbName)) {
            h2Connection.transferFolder(folder, folder, (Connection)h2NativeConnection, defaultCharsetName != null ? Charset.forName(defaultCharsetName) : null);
            this.h2Databases.add(h2DbName);
        }
        return h2Connection;
    }

    private String getH2DatabasePath(String h2DbName) {
        File h2File = new File(H2_LOCATION);
        if (!h2File.exists()) {
            h2File.mkdirs();
        }
        return H2_LOCATION + h2DbName;
    }

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith(PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        DriverPropertyInfo[] result = new DriverPropertyInfo[]{new ExtendedDriverPropertyInfo("log", "true", new String[]{"true", "false"}, "Activate driver INFO logging")};
        return result;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    private static String md5Java(String message) {
        String digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(message.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder(2 * hash.length);
            for (byte b : hash) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            digest = sb.toString();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            Logger.getLogger(JdbcDriver.class.getName()).log(Level.SEVERE, null, ex);
        }
        return digest;
    }

    static {
        try {
            DriverManager.registerDriver(new JdbcDriver());
            LOGGER.setLevel(Level.ALL);
            FileHandler fileHandler = new FileHandler(System.getProperty("user.home") + "/.DbSchema/logs/DbfJdbcDriver.log");
            fileHandler.setFormatter(new SimpleFormatter());
            LOGGER.addHandler(fileHandler);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static class ExtendedDriverPropertyInfo
    extends DriverPropertyInfo {
        ExtendedDriverPropertyInfo(String name, String value, String[] choices, String description) {
            super(name, value);
            this.description = description;
            this.choices = choices;
        }
    }
}

