/*
 * Decompiled with CFR 0.152.
 */
package com.wisecoders.dbschema.dbf;

import com.linuxense.javadbf.DBFReader;
import com.wisecoders.dbschema.dbf.JdbcDriver;
import com.wisecoders.dbschema.dbf.io.H2Loader;
import com.wisecoders.dbschema.dbf.io.H2Writer;
import com.wisecoders.dbschema.dbf.schema.Table;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.jdbc.JdbcConnection;

public class H2Connection
implements Connection {
    private static final Pattern SAVE_COMMAND_PATTERN = Pattern.compile("(\\s*)save(\\s+)dbf(\\s+)to(\\s+)(.*)", 2);
    private static final Pattern RELOAD_PATTERN = Pattern.compile("(\\s*)reload(\\s+)(.*)", 2);
    private final JdbcConnection h2Connection;
    private final String defaultCharset;

    H2Connection(JdbcConnection h2Connection, String defaultCharset) {
        this.h2Connection = h2Connection;
        this.defaultCharset = defaultCharset;
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement statement = this.h2Connection.createStatement();
        return (H2Connection)this.new StatementProxy((Object)statement).proxyStatement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement statement = this.h2Connection.createStatement(resultSetType, resultSetConcurrency);
        return (H2Connection)this.new StatementProxy((Object)statement).proxyStatement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement statement = this.h2Connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return (H2Connection)this.new StatementProxy((Object)statement).proxyStatement;
    }

    void transferFolder(File dbfFolder, File dbfSubFolder, Connection h2Connection, Charset defaultCharset) throws SQLException {
        File[] files = dbfSubFolder.listFiles();
        if (files != null) {
            for (File dbfFile : files) {
                if (dbfFile.isFile()) {
                    if (!dbfFile.getName().toLowerCase().endsWith(".dbf")) continue;
                    try (DBFReader reader = new DBFReader((InputStream)new FileInputStream(dbfFile), defaultCharset);){
                        Table table = new Table(H2Connection.extractTableNameFrom(dbfFolder, dbfFile));
                        if (H2Loader.isFileTransferred(dbfFile, h2Connection)) continue;
                        H2Loader.transfer(table, reader, h2Connection);
                        H2Loader.saveFileIntoFilesMeta(table, dbfFile, h2Connection);
                        continue;
                    }
                    catch (Exception ex) {
                        JdbcDriver.LOGGER.log(Level.SEVERE, "Error transferring " + dbfFile, ex);
                        throw new SQLException(ex.getLocalizedMessage(), ex);
                    }
                }
                if (!dbfFile.isDirectory()) continue;
                this.transferFolder(dbfFolder, dbfFile, h2Connection, defaultCharset);
            }
        }
    }

    private static String extractTableNameFrom(File dbfFolder, File dbfFile) {
        String relativePath = dbfFolder.toURI().relativize(dbfFile.toURI()).getPath();
        if (relativePath.toLowerCase().endsWith(".dbf")) {
            relativePath = relativePath.substring(0, relativePath.length() - ".dbf".length());
        }
        return relativePath;
    }

    private void saveDbf(String path) throws Exception {
        if (path == null || path.trim().length() == 0) {
            throw new SQLException("Save dbf path is empty. Please specify a directory path");
        }
        if ((path = path.trim()).startsWith("'") || path.endsWith("'") || path.startsWith("\"") || path.endsWith("\"")) {
            path = path.substring(1, path.length() - 1);
        }
        File outputFolder = new File(path);
        outputFolder.mkdirs();
        new H2Writer((Connection)this.h2Connection, outputFolder, this.defaultCharset);
    }

    private void reload(String filePath) throws Exception {
        try (PreparedStatement st = this.h2Connection.prepareStatement("DELETE FROM dbs_meta_files WHERE file_name=?");){
            st.setString(1, filePath);
            st.executeUpdate();
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.h2Connection.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.h2Connection.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.h2Connection.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.h2Connection.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.h2Connection.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.h2Connection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.h2Connection.rollback();
    }

    @Override
    public void close() throws SQLException {
        this.h2Connection.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.h2Connection.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.h2Connection.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.h2Connection.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.h2Connection.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.h2Connection.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.h2Connection.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.h2Connection.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.h2Connection.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.h2Connection.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.h2Connection.clearWarnings();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.h2Connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.h2Connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.h2Connection.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.h2Connection.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.h2Connection.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.h2Connection.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.h2Connection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.h2Connection.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.h2Connection.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.h2Connection.releaseSavepoint(savepoint);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.h2Connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.h2Connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.h2Connection.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.h2Connection.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.h2Connection.prepareStatement(sql, columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.h2Connection.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.h2Connection.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.h2Connection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.h2Connection.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.h2Connection.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.h2Connection.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.h2Connection.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.h2Connection.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.h2Connection.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.h2Connection.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.h2Connection.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.h2Connection.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.h2Connection.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.h2Connection.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.h2Connection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.h2Connection.getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.h2Connection.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.h2Connection.isWrapperFor(iface);
    }

    private class StatementProxy
    implements InvocationHandler {
        private final Object target;
        final Statement proxyStatement;

        StatementProxy(Object target) {
            this.target = target;
            this.proxyStatement = (Statement)Proxy.newProxyInstance(Statement.class.getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)this);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args != null && args.length > 0) {
                Matcher matcher = SAVE_COMMAND_PATTERN.matcher(args[0].toString());
                if (matcher.matches()) {
                    JdbcDriver.LOGGER.info("Saving dbf...");
                    long start = System.currentTimeMillis();
                    try {
                        H2Connection.this.saveDbf(matcher.group(5));
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                        throw ex;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new SQLException(ex.getLocalizedMessage(), ex);
                    }
                    args = new String[]{""};
                    long elapsed = System.currentTimeMillis() - start;
                    JdbcDriver.LOGGER.info("Executing " + method.getName() + " finished in " + elapsed + " ms");
                } else {
                    matcher = RELOAD_PATTERN.matcher(args[0].toString());
                    if (matcher.matches()) {
                        JdbcDriver.LOGGER.info("Reload " + matcher.group(3));
                        H2Connection.this.reload(matcher.group(3));
                        args = new String[]{""};
                    }
                }
            }
            return method.invoke(this.target, args);
        }
    }
}

